<?php

defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

// Include Base controller file
require APPPATH . 'controllers/Base.php';

use JeroenDesloovere\VCard\VCard;

class API extends Base {


	public function __construct ( ) {
		
		parent::__construct ( );
		
		$this->load->model ( 'user_model' );
		$this->load->library ( 'functions' );
	    $this->load->library( 'form_validation' );
	    $this->load->helper( 'url', 'form' );

	}
	
	public function index_get () {
		$this->output ( array ( 'success' => 0, 'msg' => "Unknown Method", 'http_status' => REST_Controller::HTTP_BAD_REQUEST ) );
	}

	public function register_post ( ) {
	
		$response	= array ( );
		
		$this->form_validation->set_rules ( 'first_name', 'First Name', 'trim|required' );
	    $this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
	    $this->form_validation->set_rules ( 'password', 'Password', 'trim|required|min_length[6]' );
		
		if ( $this->form_validation->run ( ) === FALSE ) {
			$response				= array (
				'success'			=> 0,
				'msg'				=> $this->get_validation_error ( ),
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
		} else if ( $this->user_model->email_exists ( $this->_args['email'] ) ) {
    		$response				= array (
    			'success'			=> 0,
    		    'msg'               => "Already registered email, try another." ,
    			'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    		);
		} else  {
		    
		    $email          = $this->_args['email'];
		    
		    $save_user		= array (
			    'email'	    => $this->_args['email'],
				'password'	=> md5 ( $this->_args['password'] )
			);
			
			if ( isset ( $this->_args['device_id'] ) ) {
			    $save_user['device_id'] = $this->_args['device_id'];
			}
			if ( isset ( $this->_args['device_name'] ) ) {
			    $save_user['device_name'] = $this->_args['device_name'];
			}
			if ( isset ( $this->_args['device_token'] ) ) {
			    $save_user['device_token'] = $this->_args['device_token'];
			}
		    $save_user['last_login'] =  date('Y-m-d H:i:s');  
			$current_user_id	= $this->user_model->insert_user ( $save_user );
			
			if ( $current_user_id > 0 ) {
			    
			    $account = array (
			        'user_id'   => $current_user_id,
			        'name'      => $this->_args['first_name']
			    );
			    if ( isset ( $this->_args['last_name'] ) ) {
    			    $account['surname'] = $this->_args['last_name'];
    			}
			    
    			$account_id = $this->user_model->save_public_account ( $account );
    			
    			$qrcode = $this->generate_profile_qrcode ( $current_user_id, $account_id );
    			    
			    if ( $qrcode ) {
    			    $token              = $this->user_model->generate_token ( $current_user_id );
        			$user               = $this->user_model->get_user ( $current_user_id );
        			//$subscription       = $this->functions->get_subscription ( $current_user_id );
        			
        			$response				= array (
        				'success'			=> 1,
        				'msg'               => 'Registered Successfully',
        				'user'              => $user,
        				//'subscription'		=> $subscription,
        				'http_status'		=> REST_Controller::HTTP_OK
        			);
			    }
			}
    	
		}

		$this->output ( $response );
	}
	
	public function login_post ( ) {
	
		$response						= array ( );
	    $this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
	    $this->form_validation->set_rules ( 'password', 'Password', 'trim|required|min_length[6]' );
		
		if ( $this->form_validation->run ( ) === FALSE ) {
		   
			$response					= array (
				'success'				=> 0,
				'msg'					=> $this->get_validation_error ( ),
				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
			);
			
		} else {
		    
			$current_user_id = $this->user_model->login ( $this->_args['email'], $this->_args['password'] );
                
			if ( $current_user_id > 0 ) {
			    
				// Token
				$token	= $this->user_model->generate_token ( $current_user_id );
				$update_user = array();
				if( isset ( $this->_args['device_id'] ) ) {
				    $update_user['device_id'] = $this->_args['device_id'];
				}
				if( isset ( $this->_args['device_name'] ) ) {
				    $update_user['device_name'] = $this->_args['device_name'];
				}
				if( isset ( $this->_args['device_token'] ) ) {
    			    $update_user['device_token'] = $this->_args['device_token'];
    			}
    			$update_user['last_login'] =  date('Y-m-d H:i:s');
			    if ( ! empty ( $update_user ) ) {
				    $this->user_model->update_user ( $current_user_id, $update_user );
			    }
				
				$user	                = $this->user_model->get_user ( $current_user_id );
				$subscription           = $this->functions->get_subscription ( $current_user_id );
				$response				= array (
					'success'			=> 1,
					'msg'               => 'Login Successfully',
					'user'				=> $user,
					'subscription'		=> $subscription,
					'http_status'		=> REST_Controller::HTTP_OK
				);
			
			} else if ( $current_user_id == '-1' ) {
			    $response				= array (
					'success'			=> 0,
					'msg' 			    => "Your account is inactive please contact administrator to activate your account.",
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
				$response				= array (
					'success'			=> 0,
					'msg' 			    => "Invalid Email or Password",
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			}
			
		}
	
		$this->output ( $response );
	}
	
	public function social_login_post ( ) {
		
		$response						= array ( );
		$this->form_validation->set_rules ( 'social_source', 'social_source', 'trim|required' );
		$this->form_validation->set_rules ( 'social_id', 'social_id', 'trim|required' );
		
		if ( $this->form_validation->run ( ) === FALSE ) {
		    
			$response					= array (
				'success'				=> 0,
				'error'					=> $this->get_validation_error ( ),
				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
			);
			
		} else {
		    $exist          =   false;
		    $social_id      =   $this->_args['social_id'];  
		    $social_source  =   $this->_args['social_source']; 
    		
    		$user	= $this->user_model->get_user_by_social ( $social_id );	
    		if ( ! empty ( $user ) ) {
    		    if ( $user['user_status'] == 1 ) {
    		        $current_user_id = $user['id'];
    		        $exist = true;
    		    } else {
    		        $response				= array (
    					'success'			=> 0,
    					'msg' 			    => "Your account is inactive please contact administrator to activate your account.",
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    				);
    		    }
    		    
    		} else {
    		    $field = array (
    		        'social_id'     => $social_id,
    		        'social_source' => $social_source,
    		    );
    		    if ( isset ( $this->_args['email'] ) && ! empty ( $this->_args['email'] ) ) {
    		        $current_user_id = $this->user_model->get_user_by_email ( $this->_args['email'] );
				    if ( $current_user_id > 0 ) {
				        $exist = true;
					    $this->user_model->update_user ( $current_user_id, $field );
				    } else {
				        $field['email'] = $this->_args['email'];
				        $current_user_id= $this->user_model->insert_user ( $field );
				    }
				} else {
				    $field['email']     = $social_id . '@' . $social_source . '.com';
				    $current_user_id	= $this->user_model->insert_user ( $field );
				}
				
				if ( isset ( $this->_args['first_name'] ) && ! empty ( $this->_args['first_name'] ) ) {
				    $update_profile['name'] = $this->_args['first_name'];
				}
				if ( isset ( $this->_args['last_name'] ) && ! empty ( $this->_args['last_name'] ) ) {
				    $update_profile['surname'] = $this->_args['last_name'];
				}
				if ( ! empty ( $update_profile ) ) {
    		        $update_profile['user_id'] = $current_user_id;
        			$account_id = $this->user_model->save_public_account ( $update_profile );
        			$qrcode = $this->generate_profile_qrcode ( $current_user_id, $account_id );
        		}
    		}
    		if ( $current_user_id > 0 ) {
    		    // Token
        		$token	= $this->user_model->generate_token ( $current_user_id );
    			$update_user = array();
    			if( isset ( $this->_args['device_id'] ) ) {
    			    $update_user['device_id'] = $this->_args['device_id'];
    			}
    			if( isset ( $this->_args['device_name'] ) ) {
    			    $update_user['device_name'] = $this->_args['device_name'];
    			}
    			if( isset ( $this->_args['device_token'] ) ) {
    			    $update_user['device_token'] = $this->_args['device_token'];
    			}
    			$update_user['last_login'] =  date('Y-m-d H:i:s');
    		    if ( ! empty ( $update_user ) ) {
    			    $this->user_model->update_user ( $current_user_id, $update_user );
    		    }
    			
    			$user	                = $this->user_model->get_user ( $current_user_id );
    			$subscription           = $this->functions->get_subscription ( $current_user_id );
    			$response				= array (
    				'success'			=> 1,
    				'msg'               => 'Login Successfully',
    				'user'				=> $user,
    				'subscription'		=> $subscription,
    				'exist'             => $exist,
    				'http_status'		=> REST_Controller::HTTP_OK
    			);
    		} else {
    		    $response				= array (
					'success'			=> 0,
					'msg' 			    => "Something went wrong.",
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
    		}
		}
	
		$this->output ( $response );
	}
	
	public function logout_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );

	
		if ( $current_user_id ) {

            $this->user_model->update_user ( $current_user_id, array ( 'token' => '', 'device_token' => '' ) );
			
			$response			= array (
				'success'		=> 1,
				'msg'           => 'Logout Successfully',
				'http_status'	=> REST_Controller::HTTP_OK
			);
			
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> 'Unauthorized.',
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
	
		$this->output ( $response );
	}
	
	public function create_profile_post ( ) {
		
		$response	= $data = array ( );
	    $current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
		    
			if ( isset ( $this->_args['designation'] ) ) {
			    $update_user['designation']   = $this->_args['designation'];
		    }
		    if ( isset ( $this->_args['description'] ) ) {
			    $update_user['description']   = $this->_args['description'];
		    }
		    
		    if ( ! empty ( $update_user ) ) {
		        $update_user['user_id'] = $current_user_id;
    			$this->user_model->save_public_account ( $update_user );
    			$user	                = $this->user_model->get_user ( $current_user_id );
			    $response				= array (
    				'success'			=> 1,
    				'user'				=> $user,
    				'http_status'		=> REST_Controller::HTTP_OK
    			);
		    } else {
		        $response				= array (
    				'success'			=> 0,
    				'msg' 			    => "Nothing to update",
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
		    }
		    
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> 'Unauthorized.',
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
				        
	}
	
	public function update_public_profile_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	    if ( $current_user_id ) {
	        
	        $this->form_validation->set_rules ( 'first_name', 'First Name', 'trim|required' );
	        //$this->form_validation->set_rules ( 'last_name', 'Last Name', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
    		    $account	        = array (
					'user_id'	    => $current_user_id,
					'name'	        => $this->_args['first_name']
				);
				
				if ( isset ( $this->_args['last_name'] ) ) {
				    $account['surname'] = $this->_args['last_name'];
				}
				
				if ( isset ( $this->_args['designation'] ) ) {
				    $account['designation'] = $this->_args['designation'];
				}
				
				if ( isset ( $this->_args['description'] ) ) {
				    $account['description'] = $this->_args['description'];
				}
	
        		$id	= $this->user_model->save_public_account ( $account );
				
				if ( $id ) {
				    $user                   = $this->user_model->get_user ( $current_user_id );
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Update successfully.',
    					'user'              => $user,
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
				}
    		    
    		}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function upload_profile_post (  ) {
		$current_user_id	= $this->validate_token ( );
		if( $current_user_id ) {
    		$response = $this->upload_file_on_server ( $current_user_id, 'profile_picture' ); 
    		if ( isset ( $response['success'] ) ) {
    			if ( $response['success'] == '1' ) {
			        $save_user		= array (
						'photo'	    => $response['file_name'],
						'user_id'   => $current_user_id
					);
					
    			    $account_id = $this->user_model->save_public_account ( $save_user );
    			    
    			    $qrcode = $this->generate_profile_qrcode ( $current_user_id, $account_id );
					if ( ! empty ( $qrcode ) ) {
					    $response['user']           = $this->user_model->get_user ( $current_user_id );
					    $response['http_status']	= REST_Controller::HTTP_OK;
					}
    			    
    			} else {
    				$response['http_status']	= REST_Controller::HTTP_BAD_REQUEST;
    			}
    		} else {
    		   $response							= array (
    				'success'						=> 0,
    				'msg'							=> $response['msg'],
    				'http_status'					=> REST_Controller::HTTP_BAD_REQUEST
    			); 
    		}
		}  else {
			$response							= array (
				'success'						=> 0,
				'error'							=> "Unauthorized.",
				'http_status'					=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
	
		$this->output ( $response );
	}

	public function upload_file_on_server ( $user_id = '', $type = NULL, $name = 'file_name' ) {
	
		$response			= array ( );

		if ( isset ( $type ) && ! empty ( $type ) ) {
		
			$this->load->library ( 'upload' );
			
			if ( $type == 'profile_picture' ) {
			    $file_prefix = "dp_";
			    $folder_name = "user_images/";
			} else if ( $type == 'file' ) {
			    $file_prefix = "";
			    $folder_name = "user_files/";
			}
			
			$upload_dir			= $this->config->item ( 'upload_dir_path' ) . $folder_name;
			$config				= array (
				'upload_path'	=> $upload_dir,
				'allowed_types'	=> 'jpg|jpeg|png|gif|pdf|doc|docx',
				'file_name'		=> $file_prefix . $user_id . '_' . time ( ),
				'max_size'      => 10240,
				'overwrite'		=> false
			);
			$this->upload->initialize ( $config );
		
			if ( $this->upload->do_upload ( $name ) ) {
				$uploaded		= $this->upload->data ( );
				
				if ( ( $type == 'profile_picture' ) && ( $name != 'cover_photo' ) ) {
				    
				    $this->load->library ( 'image_lib' );
				    
    				$configer				=  array(
    					'image_library'		=> 'gd2',
    					'source_image'		=>  $uploaded['full_path'],
    					'new_image'         =>  $upload_dir. 'thumb/' . $uploaded['file_name'],
    					'maintain_ratio'	=>  FALSE,
    					'width'				=>  150,
    					'height'			=>  150
    				);
    			
    				$this->image_lib->clear ( );
    				$this->image_lib->initialize ( $configer );
    				$this->image_lib->resize ( );
    				
				}
				
				$response					= array (
					'success'				=> 1,
					'file_name'				=> $uploaded['file_name'],
					'base_url'              => base_url ( 'public/uploads/' . $folder_name )
				);
			} else {
				$response					= array (
					'success'				=> 0,
					'msg'					=> strip_tags( $this->upload->display_errors() )
				);
			}
		}
	
		return $response;
	}
	
	public function forgot_password_post () {

		$response = array();

		$this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
		
		if ( $this->form_validation->run ( ) === FALSE ) {
		  
			$response					= array (
				'success'				=> 0,
				'msg'					=> $this->get_validation_error ( ),
				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
			);
			
		} else {
			$email = $this->_args['email'];
			$user = $this->user_model->email_exists ( $email );
			if ( ! empty ( $user )  ) {
			    
			    $rand = rand( 1000, 9999 );
			    
				$user_id = $user['id'];
				
				$update_user = array ( ); 
				$update_user['reset_pin'] = $rand;
				$this->user_model->update_user ( $user_id, $update_user );
				
				$user = $this->user_model->get_user ( $user_id );
				$search_arr = array(
					'{name}'    => $user['name'] . ' ' . $user['surname'],
					'{pin}'     => $rand
				);
				$temp_id = 1;
				$this->functions->send_email( $email, $temp_id, $search_arr );
			    
			    $response			= array (
    				'success'		=> 1,
    				'msg'           => "Change password pin is sent to your email. If you do not receive the email please check your spam.",
    				'http_status'	=> REST_Controller::HTTP_OK
    			);

			} else {
				$response			= array (
    				'success'		=> 0,
    				'msg'			=> "Entered email is not associated with any account.",
    				'http_status'	=> REST_Controller::HTTP_BAD_REQUEST
    			);
			}
		}
		
		$this->output ( $response );
		
	}
	
	function reset_pin_authenticate_post ( ) {
	    $this->form_validation->set_rules ( 'email', 'Email', 'trim|required' );
	    $this->form_validation->set_rules ( 'pin', 'PIN', 'trim|required|min_length[4]' );
		
		if ( $this->form_validation->run ( ) === FALSE ) {
		  
			$response					= array (
				'success'				=> 0,
				'msg'					=> $this->get_validation_error ( ),
				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
			);
			
		} else {
		    $email = $this->_args['email'];
		    $user = $this->user_model->email_exists ( $email );
			
			if ( ! empty ( $user ) ) {
				if ( $user['reset_pin'] == $this->_args['pin'] ) {
				    $current_user_id    = $user['id'];
				    $token	            = $this->user_model->generate_token ( $current_user_id );
				    $user               = $this->user_model->get_user ( $current_user_id );
				    $response				= array (
    					'success'			=> 1,
    					'user'				=> $user,
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
				} else {
					$response			= array (
        				'success'		=> 0,
        				'msg'           => "Invalid code",
        				'http_status'	=> REST_Controller::HTTP_BAD_REQUEST
        			);
				}
			} else {
				$response			= array (
    				'success'		=> 0,
    				'msg'           => "Invalid user!",
    				'http_status'	=> REST_Controller::HTTP_BAD_REQUEST
    			);
			}
		}
		
		$this->output ( $response );
		
	}
	
	function reset_password_post ( ) {
	    
	    $response = array();
	    $current_user_id =  $this->validate_token ( );
	    
	    if ( $current_user_id ) {
    	    $this->form_validation->set_rules('new_password','New Password','trim|required|min_length[6]');
        	$this->form_validation->set_rules('confirm_password','Confirm Password','trim|required|min_length[6]');
    		
    		if ( $this->form_validation->run ( ) === FALSE ) {
    		  
    			$response					= array (
    				'success'				=> 0,
    				'msg'					=> $this->get_validation_error ( ),
    				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
    			);
    			
    		} else if ( $this->_args['new_password'] !== $this->_args['confirm_password'] ) {
			    $response			= array (
    				'success'		=> 0,
    				'msg'           => "New Password and Confirm Password doesn't match.",
    				'http_status'	=> REST_Controller::HTTP_BAD_REQUEST
    			);
			} else {
				
    			$update_user = array( 'reset_pin' => '', 'password' => md5 ( $this->_args['new_password'] ) );
    			
                $this->user_model->update_user ( $current_user_id, $update_user );
			    $user                   = $this->user_model->get_user ( $current_user_id );
			    $response				= array (
					'success'			=> 1,
					'user'				=> $user,
					'http_status'		=> REST_Controller::HTTP_OK
				);
			}
    			
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
		
	}
	
    public function change_password_post () {
	    $response = array();
	    $current_user_id =  $this->validate_token ( );
	    
	    if ( $current_user_id ) {
	   
    	    $this->form_validation->set_rules('old_password','Old Password','trim|required|min_length[6]');
    	    $this->form_validation->set_rules('new_password','New Password','trim|required|min_length[6]');
    	    $this->form_validation->set_rules('confirm_password','Confirm Password','trim|required|min_length[6]');
    	    if($this->form_validation->run() === false){
    	        $response					= array (
    				'success'				=> 0,
    				'msg'					=> $this->get_validation_error ( ),
    				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
    			);
            } else {
    	       
                $query = $this->user_model->check_old_password ( $current_user_id, md5 ( $this->_args['old_password'] ) );
                if ( ! empty ( $query ) ) {
                   
                    if ( $this->_args['new_password'] === $this->_args['confirm_password'] ) {
                        $update_user = array();
                        $update_user['password'] = md5 ( $this->_args['new_password'] );
                        $this->user_model->update_user ( $current_user_id, $update_user );
                        $user                   = $this->user_model->get_user ( $current_user_id );
                        $response				= array (
        					'success'			=> 1,
        					'msg'               => 'Changed password successfully.',
        					'user'				=> $user,
        					'http_status'		=> REST_Controller::HTTP_OK
        				);
                   
                    } else {
                        $response				= array (
                            'success'			=> 0,
                            'msg'				=> 'New password and confirm password does not match',
                            'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
                        );
                    }
                  
                } else {
                    $response					= array (
                        'success'				=> 0,
                        'msg'					=> 'Old password does not matched',
                        'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
                    );
                }
            }
            
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
        $this->output($response);
	    
	}
	
	public function create_account_post ( ) {
	
		$response	= array ( );
		$current_user_id =  $this->validate_token ( );
		
		if ( $current_user_id ) {
		    
		    // Premium package check
    		//$subscription = $this->functions->get_subscription ( $current_user_id );
		
    		$this->form_validation->set_rules ( 'name', 'Name', 'trim|required' );
    		$this->form_validation->set_rules ( 'type', 'Type', 'trim|required' );
    		
    		$tx_id = false;
    		if ( isset ( $this->_args['tx_id'] ) && ! empty ( $this->_args['tx_id'] ) ) {
		        $tx_id  = $this->_args['tx_id'];
    	    }
    		
    		if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} /* else if ( empty ( $subscription ) && ( $this->_args['type'] != 'track' ) ) {
    		    $response					= array (
    				'success'				=> 0,
    				'msg'                   => "Subscription is required.",
    				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} */ else if ( ! in_array ( $this->_args['type'], array ( 'private', 'business', 'track' ) ) ) {
                $response				= array (
        			'success'			=> 0,
        		    'msg'               => "Type should be private|business|track",
        			'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        		);
            } else if ( empty ( $tx_id ) && $this->user_model->check_account_type_exist ( $current_user_id, $this->_args['type'] ) ) {
                $response				= array (
        			'success'			=> 1,
        		    'msg'               => "Payment is Required.",
        		    'payment'           => true,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
            } else {
                
                $type   = $this->_args['type'];
                if ( empty ( $tx_id ) && ( $type != 'track' ) ) {
                    $tx_id = $subscription['tx_id'];
                }
            
    		    $save_account	= array (
    		        'user_id'	=> $current_user_id,
    			    'type'	    => $type,
    			    'name'	    => $this->_args['name']
    			);
    			
    			if ( isset ( $this->_args['surname'] ) ) {
    			    $save_account['surname'] = $this->_args['surname'];
    			}
    			if ( isset ( $this->_args['designation'] ) ) {
    			    $save_account['designation'] = $this->_args['designation'];
    			}
    			if ( isset ( $this->_args['description'] ) ) {
    			    $save_account['description'] = $this->_args['description'];
    			}
    			if ( isset ( $this->_args['theme_color'] ) ) {
    			    $save_account['theme_color'] = $this->_args['theme_color'];
    			}
    			if ( isset ( $this->_args['icon_type'] ) ) {
    			    $save_account['icon_type'] = $this->_args['icon_type'];
    			}
    			if ( isset ( $_FILES['file_name'] ) && ! empty ( $_FILES['file_name']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'profile_picture' );
        			$save_account['photo']	= $res['file_name'];
        	    }
        	    if ( isset ( $_FILES['cover_photo'] ) && ! empty ( $_FILES['cover_photo']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'profile_picture', 'cover_photo' );
        			$save_account['cover_photo']	= $res['file_name'];
        	    }
        	    
        	    $account_id = $this->user_model->save_account ( $save_account );
        	    
    			if ( $account_id > 0 ) {
    			    
    			    if ( $type == 'track' ) {
    			        $save_track = array ( 'account_id' => $account_id );
                        if ( isset ( $this->_args['sub_type'] ) ) {
            			    $save_track['sub_type'] = $this->_args['sub_type'];
            		    }
            		    if ( isset ( $this->_args['age'] ) ) {
            			    $save_track['age'] = $this->_args['age'];
            		    }
            		    if ( isset ( $this->_args['whatsapp_no'] ) ) {
            			    $save_track['whatsapp_no'] = $this->_args['whatsapp_no'];
            		    }
            		    if ( isset ( $this->_args['father_name'] ) ) {
            			    $save_track['father_name'] = $this->_args['father_name'];
            		    }
            		    if ( isset ( $this->_args['mother_name'] ) ) {
            			    $save_track['mother_name'] = $this->_args['mother_name'];
            		    }
            		    if ( isset ( $this->_args['dob'] ) ) {
            			    $save_track['dob'] = $this->_args['dob'];
            		    }
            		    if ( isset ( $this->_args['address'] ) ) {
            			    $save_track['address'] = $this->_args['address'];
            		    }
            		    if ( isset ( $this->_args['category'] ) ) {
            			    $save_track['category'] = $this->_args['category'];
            		    }
            		    if ( isset ( $this->_args['gender'] ) ) {
            			    $save_track['gender'] = $this->_args['gender'];
            		    }
            		    if ( isset ( $this->_args['color'] ) ) {
            			    $save_track['color'] = $this->_args['color'];
            		    }
            		    if ( isset ( $this->_args['breed'] ) ) {
            			    $save_track['breed'] = $this->_args['breed'];
            		    }
            		    if ( isset ( $this->_args['vac_details'] ) ) {
            			    $save_track['vac_details'] = $this->_args['vac_details'];
            		    }
            		    if ( isset ( $this->_args['next_vac_details'] ) ) {
            			    $save_track['next_vac_details'] = $this->_args['next_vac_details'];
            		    }
            		    if ( isset ( $this->_args['vet_info'] ) ) {
            			    $save_track['vet_info'] = $this->_args['vet_info'];
            		    }
            		    if ( isset ( $this->_args['owner_name'] ) ) {
            			    $save_track['owner_name'] = $this->_args['owner_name'];
            		    }
            		    if ( isset ( $this->_args['owner_contact'] ) ) {
            			    $save_track['owner_contact'] = $this->_args['owner_contact'];
            		    }
            		    if ( isset ( $this->_args['address_link'] ) ) {
            			    $save_track['address_link'] = $this->_args['address_link'];
            		    }
            		    if ( isset ( $this->_args['brand'] ) ) {
            			    $save_track['brand'] = $this->_args['brand'];
            		    }
            		    if ( isset ( $this->_args['marked_missed'] ) ) {
            			    $save_track['marked_missed'] = $this->_args['marked_missed'];
            		    }
            		    
            		    $this->user_model->save_track_details ( $save_track );
        			}
    			    
    			    $qrcode = $this->generate_profile_qrcode ( $current_user_id, $account_id );
    			    
    			    if ( $qrcode ) {
                        $account = $this->user_model->get_account ( $account_id );
                        $account['profile_url'] = base_url ( 'profile/' . $qrcode );
                        
                        $transaction = array (
                	        'user_id'       => $current_user_id,
                	        'account_id'    => $account_id,
                	        'tx_id'         => $tx_id
                	    );
                	    $this->functions->insert_transaction ( $transaction );
            			
            			$response				= array (
            				'success'			=> 1,
            				'msg'               => 'Saved Successfully.',
            				'item'              => $account,
            				'payment'           => false,
            				'http_status'		=> REST_Controller::HTTP_OK
            			);
    			    }
    			}
        	
    		}
    		
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	}
	
	public function update_account_post ( ) {
	
		$response = $save_account = array ( );
		$current_user_id =  $this->validate_token ( );
		
		if ( $current_user_id ) {
		    
		    $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required|numeric' );
    		
    		if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else  {
    		    
    		    $account_id = $this->_args['account_id'];
		
    			if ( isset ( $this->_args['name'] ) ) {
    			    $save_account['name'] = $this->_args['name'];
    			}
    			if ( isset ( $this->_args['surname'] ) ) {
    			    $save_account['surname'] = $this->_args['surname'];
    			}
    			if ( isset ( $this->_args['designation'] ) ) {
    			    $save_account['designation'] = $this->_args['designation'];
    			}
    			if ( isset ( $this->_args['description'] ) ) {
    			    $save_account['description'] = $this->_args['description'];
    			}
    			if ( isset ( $this->_args['theme_color'] ) ) {
    			    $save_account['theme_color'] = $this->_args['theme_color'];
    			}
    			if ( isset ( $this->_args['icon_type'] ) ) {
    			    $save_account['icon_type'] = $this->_args['icon_type'];
    			}
    			if ( isset ( $this->_args['btn_color'] ) ) {
            	    $save_account['btn_color'] = $this->_args['btn_color'];
    			}
    			if ( isset ( $this->_args['icon_color'] ) ) {
    			    $save_account['icon_color'] = $this->_args['icon_color'];
    			}
    			if ( isset ( $this->_args['status'] ) ) {
    			    $save_account['status'] = $this->_args['status'];
    			}
    			if ( isset ( $_FILES['file_name'] ) && ! empty ( $_FILES['file_name']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'profile_picture' );
        			$save_account['photo']	= $res['file_name'];
        	    }
        	    if ( isset ( $_FILES['logo'] ) && ! empty ( $_FILES['logo']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'profile_picture' );
        			$save_account['logo']	= $res['file_name'];
        	    }
        	    if ( isset ( $_FILES['cover_photo'] ) && ! empty ( $_FILES['cover_photo']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'profile_picture', 'cover_photo' );
        			$save_account['cover_photo']	= $res['cover_photo'];
        	    }
        	    
                if ( isset ( $this->_args['sub_type'] ) ) {
    			    $save_track['sub_type'] = $this->_args['sub_type'];
    		    }
    		    if ( isset ( $this->_args['age'] ) ) {
    			    $save_track['age'] = $this->_args['age'];
    		    }
    		    if ( isset ( $this->_args['whatsapp_no'] ) ) {
    			    $save_track['whatsapp_no'] = $this->_args['whatsapp_no'];
    		    }
    		    if ( isset ( $this->_args['father_name'] ) ) {
    			    $save_track['father_name'] = $this->_args['father_name'];
    		    }
    		    if ( isset ( $this->_args['mother_name'] ) ) {
    			    $save_track['mother_name'] = $this->_args['mother_name'];
    		    }
    		    if ( isset ( $this->_args['dob'] ) ) {
    			    $save_track['dob'] = $this->_args['dob'];
    		    }
    		    if ( isset ( $this->_args['address'] ) ) {
    			    $save_track['address'] = $this->_args['address'];
    		    }
    		    if ( isset ( $this->_args['category'] ) ) {
    			    $save_track['category'] = $this->_args['category'];
    		    }
    		    if ( isset ( $this->_args['gender'] ) ) {
    			    $save_track['gender'] = $this->_args['gender'];
    		    }
    		    if ( isset ( $this->_args['color'] ) ) {
    			    $save_track['color'] = $this->_args['color'];
    		    }
    		    if ( isset ( $this->_args['breed'] ) ) {
    			    $save_track['breed'] = $this->_args['breed'];
    		    }
    		    if ( isset ( $this->_args['vac_details'] ) ) {
    			    $save_track['vac_details'] = $this->_args['vac_details'];
    		    }
    		    if ( isset ( $this->_args['next_vac_details'] ) ) {
    			    $save_track['next_vac_details'] = $this->_args['next_vac_details'];
    		    }
    		    if ( isset ( $this->_args['vet_info'] ) ) {
    			    $save_track['vet_info'] = $this->_args['vet_info'];
    		    }
    		    if ( isset ( $this->_args['owner_name'] ) ) {
    			    $save_track['owner_name'] = $this->_args['owner_name'];
    		    }
    		    if ( isset ( $this->_args['owner_contact'] ) ) {
    			    $save_track['owner_contact'] = $this->_args['owner_contact'];
    		    }
    		    if ( isset ( $this->_args['address_link'] ) ) {
    			    $save_track['address_link'] = $this->_args['address_link'];
    		    }
    		    if ( isset ( $this->_args['brand'] ) ) {
    			    $save_track['brand'] = $this->_args['brand'];
    		    }
    		    if ( isset ( $this->_args['marked_missed'] ) ) {
    			    $save_track['marked_missed'] = $this->_args['marked_missed'];
    		    }
    		    
        	    if ( ! empty ( $save_account ) || ! empty ( $save_track ) ) {
        	        if ( ! empty ( $save_account ) ) {
            	        $save_account['account_id'] = $account_id;
            	        $save_account['user_id']    = $current_user_id;
            	        $this->user_model->save_account ( $save_account );
        	        }
        	        
        	        if ( ! empty ( $save_track ) ) {
            	        $save_track['account_id']   =  $account_id;
            	        $this->user_model->save_track_details ( $save_track );
        	        }
        	        
        	        if ( isset ( $save_account['photo'] ) && ! empty ( $save_account['photo'] ) ) {
        	            $qrcode = $this->generate_profile_qrcode ( $current_user_id, $account_id );
        	        }
        	        
                    $account                = $this->user_model->get_account ( $account_id );
                    if ( ! empty ( $account ) ) {
                        $account['profile_url'] = base_url ( 'profile/' . $account['profile_id'] );
            			$response				= array (
            				'success'			=> 1,
            				'msg'               => 'Saved Successfully.',
            				'item'              => $account,
            				'http_status'		=> REST_Controller::HTTP_OK
            			);
                    } else {
                        $response				= array (
            				'success'			=> 0,
            				'msg' 			    => "Account ID not found.",
        					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
            			);
                    }
        			
        	    } else {
    		        $response				= array (
        				'success'			=> 0,
        				'msg' 			    => "Nothing to update",
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        			);
    		    }
        	    
    		}
    		
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	}
	
	public function get_account_post ( ) {
	
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
		
		if ( $current_user_id ) {
		   $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required|numeric' );
    		
    		if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else  {
    		   $account_id              = $this->_args['account_id'];
    		   $accounts                = $this->user_model->get_account ( $account_id );
    		   $response				= array (
    				'success'			=> 1,
    				'item'              => $accounts,
    				'http_status'		=> REST_Controller::HTTP_OK
    			);
    		}
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	}
	
	public function get_user_accounts_post ( ) {
	
		$response = $save_account = array ( );
		$current_user_id =  $this->validate_token ( );
		
		if ( $current_user_id ) {
		   $type = false;
		   if ( isset ( $this->_args['type'] ) ) {
	            $type  = $this->_args['type'];
	       }
		   $accounts                = $this->user_model->get_user_accounts ( $current_user_id, $type );
		   $user                    = $this->user_model->get_user ( $current_user_id );
		   $response				= array (
				'success'			=> 1,
				'items'             => $accounts,
				'user'				=> $user,
				'http_status'		=> REST_Controller::HTTP_OK
			);
    		
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	}
	
	public function contact_us_post () {
	    $response  = array();

        $this->form_validation->set_rules('name','Name','trim|required');
        $this->form_validation->set_rules('email','Email','trim|required|valid_email');
        $this->form_validation->set_rules('message','Message','trim|required');
        
        if ( $this->form_validation->run() == false ) {
            
            $response				= array (
				'success'			=> 0,
				'msg'				=> $this->get_validation_error ( ),
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
            
        } else {
            
            $message = '';
	        
	        $name       = $this->_args['name'];
	        $email      = $this->_args['email'];
	        $phone      = '';
	        if ( isset ( $this->_args['phone'] ) ) {
	            $phone  = $this->_args['phone'];
	        }
	        $msg        = $this->_args['message'];
	        
	        if ( isset ( $this->_args['subject'] ) && ! empty ( $this->_args['subject'] ) ) {
	            $message .= 'Subject: '. $this->_args['subject'] . '<br><br>';
	        }
	        $message .= 'Name: '. $name . '<br><br>';
	        $message .= 'Email: '. $email . '<br><br>';
	        if ( ! empty ( $phone ) ) {
	            $message .= 'Phone: '. $phone . '<br><br>';
	        }
	        
			$message .= $msg;
 
			$search_arr			= array(
				'{content}'		=> nl2br ( $message )
			);
				
			$temp_id	            = 2;
			$admin_email_settings   = $this->config->item ( 'admin_email_settings' );
			$to = $admin_email_settings['admin_email'];
			$sent = $this->functions->send_email ( $to, $temp_id, $search_arr );
		    if ( $sent ) {
    			$response				= array (
    				'success'			=> 1,
    				'msg'				=> 'Sent Successfully.',
    				'http_status'		=> REST_Controller::HTTP_OK
    			);
		    }
            
	    }
	   
	    $this->output($response);
	}

	public function get_user_post ( ) {
	    
	    $response		= array ( );
        
	    if ( isset ( $this->_args['target_user_id'] ) && ( $this->_args['target_user_id'] > 0 ) ) {
	        $target_user_id     = $this->_args['target_user_id'];
	        $current_user_id	= $this->validate_token ( );
	    } else {
	        $target_user_id	    = $this->validate_token ( );
	    }
	        
	    $user                   = $this->user_model->get_user ( $target_user_id );
	    
	    $response				= array (
			'success'			=> 1,
			'user'				=> $user,
			'base_url'          => base_url ( 'public/uploads/user_images' ),
			'http_status'		=> REST_Controller::HTTP_OK
		);
		
		$this->output ( $response );
		
	}
	
	public function get_app_icons_post ( ) {
		$response = array ( );
		
		$current_user_id =  $this->validate_token ( );
		if ( $current_user_id ) {
		    
		    if ( isset ( $this->_args['account_id'] ) && $this->_args['account_id'] > 0 ) {
        		$account_id = $this->_args['account_id'];
            	$apps   = $this->user_model->get_user_apps ( $current_user_id, $account_id );
            	$new_apps = array();
            	if ( ! empty ( $apps ) ) {
                	foreach ( $apps as $app ) {
                	    $new_apps[$app['slug']] = $app;
                	}
            	}
    		}
		
    		$app_icons = $this->user_model->get_app_icons ( );
    		$services = array ();
    		if ( ! empty ( $app_icons ) ) {
        	    foreach ( $app_icons as $ai ) {
        	        $services[$ai['slug']] = $ai;
        	    }
    		}
    		
    		global $app_arr;
    		if ( ! empty ( $app_arr ) ) {
    		    foreach ( $app_arr as $x => $app ) {
    		        foreach ( $app['apps'] as $y =>  $slug ) {
    		            $app_arr[$x]['apps'][$y] = $services[$slug];
    		            if (isset($new_apps[$slug])) {
    		                $app_arr[$x]['apps'][$y]['data'] = $new_apps[$slug];
    		            } else {
    		                $app_arr[$x]['apps'][$y]['data'] = NULL;
    		            }
    		        }
    		    }
    		}
    		
    		//echo "<pre>"; print_r($app_arr); die;
    		$response			= array (
    			'success'		=> 1,
    			'items'	        => $app_arr,
    			'base_url'      => base_url ( 'public/uploads/app_icons' ),
    			'http_status'	=> REST_Controller::HTTP_OK
    		);
    	} else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function save_user_app_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	    if ( $current_user_id ) {
	        
	        $this->form_validation->set_rules ( 'slug', 'Slug', 'trim|required' );
	        $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
    		    $add = '';
    		    $save_service	= array (
					'user_id'	    => $current_user_id,
					'account_id'	=> $this->_args['account_id'],
					'slug'	        => $this->_args['slug']
				);
				
				if ( isset ( $this->_args['title'] ) ) {
				    $save_service['title'] = $this->_args['title'];
				}
				
				if ( isset ( $this->_args['content'] ) ) {
				    $save_service['content'] = $this->_args['content'];
				}
			
				if ( isset ( $this->_args['id'] ) && $this->_args['id'] > 0 ) {
				    $save_service['id'] = $this->_args['id'];
				}
				
        		if ( isset ( $_FILES['file_name'] ) && ! empty ( $_FILES['file_name']['name'] ) ) {
    				$upload = $this->upload_file_on_server ( $current_user_id, 'file' );
    				if ( isset ( $upload['success'] ) && $upload['success'] == '1' ) {
    				    $save_service['file_name']	= $upload['file_name'];
    				}
			    }
        		
        		$id	= $this->user_model->save_user_app ( $save_service );
				
				if ( $id ) {
				    $item = $this->user_model->get_user_app ( $id );
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Saved successfully.',
    					'item'              => $item,
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
				} else {
				     $response				= array (
        				'success'			=> 0,
        				'msg' 			    => "Error invalid ID!",
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        			);
				}
    		    
    		}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function get_user_apps_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $account_id         = $this->_args['account_id'];
			    $account            = $this->user_model->get_account ( $account_id );
			    $account['mode']    = $this->user_model->get_theme_mode_by_color ( $account['theme_color'] );
        		$items              = $this->user_model->get_user_apps ( $current_user_id, $account_id );
        		$connect_status     = $this->user_model->check_connect_status ( $current_user_id, $account_id );
        		$response			= array (
        			'success'		=> 1,
        			'items'	        => $items,
        			'account'	    => $account,
        			'connect_status'=> $connect_status,
        			'http_status'	=> REST_Controller::HTTP_OK
        		);
			}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function delete_user_apps_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
		    $this->form_validation->set_rules ( 'id', 'ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $id = $this->_args['id'];
    			$this->user_model->delete_user_app ( $current_user_id, $id );
        		$response				= array (
        			'success'			=> 1,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
		} else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
	
		$this->output ( $response );
	}
	
	public function delete_account_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $account_id = $this->_args['account_id'];
    			$this->user_model->delete_account ( $current_user_id, $account_id );
        		$response				= array (
        			'success'			=> 1,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function delete_public_account_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
			$this->user_model->delete_public_account ( $current_user_id );
    		$response				= array (
    			'success'			=> 1,
    			'http_status'		=> REST_Controller::HTTP_OK
    		);
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function toggle_direct_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        
	        
	        $this->form_validation->set_rules ( 'id', 'ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $id     = $this->_args['id'];
			    $direct = 0;
			    if ( isset ( $this->_args['direct'] ) ) {
				    $direct = $this->_args['direct'];
				}
    			$this->user_model->toggle_direct ( $current_user_id, $id, $direct );
        		$response				= array (
        			'success'			=> 1,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function update_app_order_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        
	        $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );
	        $this->form_validation->set_rules ( 'order_ids', "Order ID's", 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $account_id     = $this->_args['account_id'];
			    $order_ids      = $this->_args['order_ids'];
			    $order_ids      = json_decode ( $order_ids );
			    if ( ! empty ( $order_ids ) ) {
			        $app_order = 1;
			        foreach ( $order_ids as $id ) {
			            if ( $id > 0 ) {
			                $this->user_model->update_apps_order ( $current_user_id, $account_id, $id, $app_order );
			                $app_order++;
			            }
			        }
				}
        		$response				= array (
        			'success'			=> 1,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function save_user_device_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	    if ( $current_user_id ) {
	        
	        $this->form_validation->set_rules ( 'tag_id', 'Tag ID', 'trim|required' );
	        $this->form_validation->set_rules ( 'type_id', 'Type ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else if ( $this->user_model->tag_exists ( $this->_args['tag_id'], $current_user_id ) ) {
        		$response				= array (
        			'success'			=> 0,
        		    'msg'               => "Tag ID is already activated from another user please try with another one." ,
        			'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        		);
    		} /*else if ( ! in_array ( $this->_args['type'], array ( 'tag', 'keyring', 'card', 'bluetooth' ) ) ) {
        		$response				= array (
        			'success'			=> 0,
        		    'msg'               => "Type should be tag|keyring|card|bluetooth." ,
        			'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        		);
    		} */ else { 
    		    $tag_id                 =  $this->_args['tag_id'];
    		    $type_id                =  $this->_args['type_id'];
    		    $save_nfctag	        = array (
					'tag_id'	        => $tag_id,
					'user_id'	        => $current_user_id,
					'type_id'           => $type_id
				);
				
				if ( isset ( $this->_args['account_id'] ) && ( $this->_args['account_id'] > 0 || $this->_args['account_id'] == '-1' ) ) {
				    $save_nfctag['account_id'] = $this->_args['account_id'];
				} else {
				    // set public account_id by default
				    $user   = $this->user_model->get_user ( $current_user_id );
				    $save_nfctag['account_id'] = $user['account_id'];
				}
				
				if ( isset ( $this->_args['tag_name'] ) ) {
				    $save_nfctag['tag_name'] = $this->_args['tag_name'];
				}
				if ( isset ( $this->_args['lock_status'] ) ) {
				    $save_nfctag['lock_status'] = $this->_args['lock_status'];
				}
				
				$save	= $this->user_model->save_user_device ( $save_nfctag );
				
				$device_url                 = base_url ( 'device/' . $tag_id );
				if ( $save ) {
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Saved successfully.',
    					'device_url'        => $device_url,
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
				}
    		    
    		}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function remove_user_device_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        $this->form_validation->set_rules ( 'tag_id', 'Tag ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $tag_id = $this->_args['tag_id'];
			    $save_nfctag = array ( 'tag_id' => $tag_id, 'user_id' => 0, 'account_id' => 0 );
    			$save	= $this->user_model->save_user_device ( $save_nfctag );
        		$response				= array (
        			'success'			=> 1,
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function get_user_devices_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        
    		$items   = $this->user_model->get_user_devices ( $current_user_id );
    		if ( ! empty ( $items ) ) {
    		    foreach ( $items as $k => $item ) {
    		        $type = $this->user_model->get_device_type ( $item['type_id'] );
    		        $items[$k]['image'] = $type['image'];
    		    }
    		}
    		$response			= array (
    			'success'		=> 1,
    			'items'	        => $items,
    			'http_status'	=> REST_Controller::HTTP_OK
    		);
			
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function get_device_types_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	
	    if ( $current_user_id ) {
	        
    		$items   = $this->user_model->get_device_types ( $current_user_id );
    		$response			= array (
    			'success'		=> 1,
    			'items'	        => $items,
    			'http_status'	=> REST_Controller::HTTP_OK
    		);
			
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	public function save_connect_post ( ) {
	    
	    $response	= array ( );
	    
	    if ( isset ( $this->_args['user_id'] ) ) {
		    $current_user_id =  $this->_args['user_id'];
		} else {
		    $current_user_id =  $this->validate_token ();
		}
		
	    if ( $current_user_id ) {
	        
    	    $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    
		        $data = array (
					'user_id'			=> $current_user_id,
					'account_id'	    => $this->_args['account_id']
				);
				if ( isset ( $this->_args['lat'] ) ) {
				    $data['lat'] = $this->_args['lat'];
				}
				if ( isset ( $this->_args['lng'] ) ) {
				    $data['lng'] = $this->_args['lng'];
				}
		        $connect = $this->user_model->save_connect ( $data );
		        if ( $connect == 1 ) {
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Connect saved successfully.',
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
		        } else if ( $connect == 2 ) {
		            $response				= array (
    					'success'			=> 1,
    					'msg'               => 'Connect is already saved.',
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
		        } else {
		            $response				= array (
    					'success'			=> 0,
    					'msg'               => 'Something went wrong, please try again later.',
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    				);
		        }
			    
			}
	
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	    
	}
	
	public function remove_connect_post ( ) {
	    
	    $response	= array ( );
	    
	    if ( isset ( $this->_args['user_id'] ) ) {
		    $current_user_id =  $this->_args['user_id'];
		} else {
		    $current_user_id =  $this->validate_token ();
		}
		
	    if ( $current_user_id ) {
	        
    	    $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    
		        $this->user_model->delete_connect ( $current_user_id, $this->_args['account_id'] );
		        $response				= array (
					'success'			=> 1,
					'msg'               => 'Connect delete successfully.',
					'http_status'		=> REST_Controller::HTTP_OK
				);
			    
			}
	
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	    
	}
	
	public function get_connects_post ( ) {
	    
	    $response		    = array ( );
        
	    $current_user_id	= $this->validate_token ( );
	    
	    if ( $current_user_id ) {   
	        
	        $args = array ( 'user_id' => $current_user_id );
	        
		    if ( isset ( $this->_args['limit'] ) ) {
			    $args['limit']	= $this->_args['limit'];
		    } else {
		        $args['limit']	= 25;
		    }
		    $current_page	= ( isset ( $this->_args['page'] ) ) ? $this->_args['page'] : 1;
			$args['offset']	= ( $current_page - 1 ) * $args['limit'];

    	    $items          = $this->user_model->get_connects ( $args );
    	    
    	    $args['count']	= true;
			$total_items	= $this->user_model->get_connects ( $args );
		
			if ( empty ( $total_items ) ) {
				$total_items	= "0";
			}
			
    	    $response				= array (
    			'success'			=> 1,
    			'items'				=> $items,
    			'total_items'       => ( int ) $total_items, 
    			'current_page'      => ( int ) $current_page, 
    			'http_status'		=> REST_Controller::HTTP_OK
    		);
	    } else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
		
	}
	
	public function export_connect_get ( ) {
	    
		$response = array ( );
		
		if ( isset ( $this->_args['account_id'] ) && ! empty ( $this->_args['account_id'] ) ) {
		    
		    $account_id = base64_decode ( $this->_args['account_id'] );
		    //$account_id = $this->_args['account_id'];
		    $user       = $this->user_model->get_account ( $account_id );
		    
			if ( ! empty ( $user ) && ( ! empty ( $user['name'] ) OR ! empty ( $user['surname'] ) ) ) {
			    
    		    extract ( $user );
    		    
    		    $vcard = new VCard();
    
                if ( isset ( $name ) && ! empty ( $name ) ) {
                    $vcard->addName( $name, (isset($surname)?$surname:'') );
                }
                if ( isset ( $photo ) && ! empty ( $photo ) ) {
                    $photo  = base_url ( 'public/uploads/user_images/' . $photo );
                    $vcard->addPhoto( $photo );
                }
                if ( isset ( $designation ) && ! empty ( $designation ) ) {
                    $vcard->addJobtitle( $designation );
                }
                if ( isset ( $description ) && ! empty ( $description ) ) {
                    $vcard->addNote( $description );
                }
                
                $email = '';
                /*if ( $type == 'public' ) {
                    $email  = $this->user_model->get_public_email ( $user_id);
                    if ( isset ( $email ) && ! empty ( $email ) ) {
                        $vcard->addEmail( $email, 'HOME' );
                    }
                }*/
                
                $profile_url = base_url ( 'profile/' . $profile_id );
                $vcard->addItem( 'item1.URL', $profile_url );
                $vcard->addItem( 'item1.X-ABLabel', 'Profile' );
                
                $apps   = $this->user_model->get_user_apps ( $user_id, $account_id );
                $i = 2;
                if ( ! empty ( $apps ) ) {
                    foreach ( $apps as $app ) {
                        if ( ( $app['slug'] == 'phone' ) && ! empty ( $app['content'] ) ) {
                                $vcard->addPhoneNumber( $app['content'], 'WORK' );
                        } else if ( ( $app['slug'] == 'email' ) && ! empty ( $app['content'] ) && ( strtolower( $app['content'] ) != strtolower( $email ) ) ) {
                                $vcard->addEmail( $app['content'], 'WORK' );
                        } else if ( ! empty ( $app['content'] ) ) {
                            $content = $app['content'];
                            if ( ( strstr ( $content, "https://" ) !== false ) || ( strstr ( $content, "http://" ) !== false ) ) {
                                $url = $content;
                            } else {
                                $url = $app['base_url'].$content;
                            }
                            $vcard->addItem( 'item'.$i.'.URL', $url );
                            $vcard->addItem( 'item'.$i.'.X-ABLabel', $app['title'] );
                            $i++;
                        }
                    }
                }
                
                $vcard->setFilename( $name . (isset($surname)?' '.$surname:'') );
                
                return $vcard->download();
			} else {
			    $response				= array (
    				'success'			=> 0,
    				'msg'				=> 'Account is empty.',
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
			}
    		
		} else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Invalid User.',
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
		}
		$this->output ( $response );
	}
	
	function profile_get ( $profile_id ) {
	    
	    $data = array();

        $user = $this->user_model->get_account_by_profile ( $profile_id );
		if ( ! empty ( $user ) && ( isset ( $user['status'] ) && ( $user['status'] == 1 ) ) ) {
		    if ( $user['type'] == 'track' ) { 
		        $message = "Someone scanned your ".$user['name'];
    			$search_arr			= array(
    				'{content}'		=> nl2br ( $message )
    			);
    				
    			$temp_id	        = 3;
    			
    			$to     = $user['email'];
    			$sent = $this->functions->send_email ( $to, $temp_id, $search_arr );
		    }
		    $user_id               = $user["user_id"];
		    $account_id            = $user["account_id"];
		    $user['cover_photo']   = $this->user_model->get_public_photo ( $user_id );
		    $user['apps']          = $this->user_model->get_user_apps ( $user_id, $account_id );
		    $subscription          = $this->functions->get_subscription ( $user_id );
		    $data['mode']          = $this->user_model->get_theme_mode_by_color ( $user['theme_color'] );
		    $data['user']          = $user;
		    
		    if ( empty ( $subscription ) ) {
		        $data['mode'] = "dark";
		        $data['user']['theme_color'] = "#ffffff";
		    }
		    
		    $this->load->view ( 'profile', $data );
		} else {
		    $data['user']   = array();
		    $this->load->view ( 'profile_404', $data );
		}
	        
	}
	
	function nfc_get ( $tag_id = false ) {
	    
	    $data = array();
        $status   = 0;
        if ( ! empty ( $tag_id ) ) {
            $devices = $this->user_model->tag_exists ( $tag_id );
    		if ( ! empty ( $devices ) ) {
    		    if ( $devices['account_id'] > 0 ) {
    		        if ( $devices['lock_status'] != 1 ) {
        		        $account    = $this->user_model->get_account ( $devices['account_id'] );
                        $url        = base_url ( 'profile/' . $account['profile_id'] );
        		        redirect ( $url );
    		        } else {
    		            $status   = 'Device is locked.';
    		        }
    		    } else {
    		        $status   = 'Device is empty.';
    		    }
    		} else {
    		    $status   = 'No device found.';
    		}
        } else {
            $status   = 'Tag id should not empty.';
        }
		$data['status'] = $status;
	    $this->load->view ( 'profile_404', $data );   
	}
	
	function get_account_by_profile_post ( ) {
	    
	    $response = array ( );
	    $current_user_id	= $this->validate_token ( );
	    
	    if ( $current_user_id ) { 
   
    	    $this->form_validation->set_rules ( 'profile_id', 'Profile ID', 'trim|required' );   
    	    if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
    		} else {
    		    $account        = $this->user_model->get_account_by_profile ( $this->_args['profile_id'] );
    		    if ( ! empty ( $account ) ) {
    		        if ( isset ( $account['status'] ) && ( $account['status'] == 1 ) ) {
            		    $account_id         = $account['account_id'];
            		    $user_id            = $account['user_id'];
                		$items              = $this->user_model->get_user_apps ( $user_id, $account_id );
                		$connect_status     = $this->user_model->check_connect_status ( $current_user_id, $account_id );
                		$account['mode']    = $this->user_model->get_theme_mode_by_color ( $account['theme_color'] );
            		    $response			= array (
                			'success'		=> 1,
                			'account'	    => $account,
                			'items'	        => $items,
                			'connect_status'=> $connect_status,
                			'http_status'	=> REST_Controller::HTTP_OK
                		);
    		        } else {
    		            $response				= array (
        					'success'			=> 0,
        					'msg'				=> 'Account is not active.',
        					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        				);
    		        }
    		    } else {
    		        $response				= array (
    					'success'			=> 0,
    					'msg'				=> 'Account not found.',
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    				);
    		    }
    		}
    		
	    } else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
        $this->output ( $response );
        
	}
	
	function get_account_by_tag_post ( ) {
	    
	    $response = array ( );
	    $current_user_id	= $this->validate_token ( );
	    
	    if ( $current_user_id ) { 
   
    	    $this->form_validation->set_rules ( 'tag_id', 'Tag ID', 'trim|required' );   
    	    if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
    		} else {
        		$devices            = $this->user_model->tag_exists ( $this->_args['tag_id'] );
    		    
    		    if ( ! empty ( $devices ) ) {
        		    if ( $devices['account_id'] > 0 ) {
        		        if ( $devices['lock_status'] != 1 ) {
            		        $account    = $this->user_model->get_account ( $devices['account_id'] );
            		        if ( ! empty ( $account ) ) {
                    		    $account_id         = $account['account_id'];
                    		    $user_id            = $account['user_id'];
                        		$items              = $this->user_model->get_user_apps ( $user_id, $account_id );
                        		$connect_status     = $this->user_model->check_connect_status ( $user_id, $account_id );
                        		$account['mode']    = $this->user_model->get_theme_mode_by_color ( $account['theme_color'] );
                        		
                        		$subscription       = $this->functions->get_subscription ( $user_id );
                        		if ( empty ( $subscription ) ) {
                        		    $account['mode'] = 'dark';
                        		    $account['theme_color'] = '#ffffff';
                        		}
                    		    $response			= array (
                        			'success'		=> 1,
                        			'account'	    => $account,
                        			'items'	        => $items,
                        			'connect_status'=> $connect_status,
                        			'subscription'  => $subscription,
                        			'http_status'	=> REST_Controller::HTTP_OK
                        		);
                		    }  else {
                		        $response				= array (
                					'success'			=> 0,
                					'msg'				=> 'Account not found.',
                					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
                				);
                		    }
                            
        		        } else {
        		            $response				= array (
            					'success'			=> 0,
            					'msg'				=> 'Device is locked.',
            					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
            				);
        		        }
        		    } else {
        		        $response				= array (
        					'success'			=> 0,
        					'msg'				=> 'Device is empty.',
        					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        				);
        		    }
        		} else {
        		    $response				= array (
    					'success'			=> 0,
    					'msg'				=> 'No device found.',
    					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    				);
        		}
    		    
    		}
    		
	    } else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
        $this->output ( $response );
        
	}
	
	public function send_connect_email_post () {
	    $response = array ( );
	    $this->form_validation->set_rules ( 'name', 'Name', 'trim|required' );   
        $this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
        $this->form_validation->set_rules ( 'phone', 'Phone', 'trim|required' );
        $this->form_validation->set_rules ( 'user_id', 'User_id', 'required' );
        
		if ( $this->form_validation->run ( ) === FALSE ) {
		    $errors			    = $this->form_validation->error_array ( );
			$response		    = array (
				'success'	    => 0,
				'msg'		    => $errors,
				'http_status'	=> REST_Controller::HTTP_BAD_REQUEST
			);
		} else {
	        $map_url = $message = '';
	        
	        $name       = $this->input->post('name');
	        $email      = $this->input->post('email');
	        $phone      = $this->input->post('phone');
	        $user_id    = $this->input->post('user_id');
            $lat        = $this->input->post('lat');
            $lng        = $this->input->post('lng');
            if ( ! empty ( $lat ) && ! empty ( $lng ) ) {
	            $map_url = "https://www.google.com/maps/?q=$lat,$lng";
            }
	        
	        $message .= 'Name: '. $name . '<br><br>';
	        $message .= 'Email: '. $email . '<br><br>';
	        $message .= 'Phone: '. $phone. '<br><br>';;
	        if ( ! empty ( $map_url ) ) {
	            $message .= 'Current Location: '. $map_url;
	        }
 
			$search_arr			= array(
				'{content}'		=> nl2br ( $message )
			);
				
			$temp_id	        = 3;
			
			$user   = $this->user_model->get_user ( $user_id );
			$to     = $user['email'];
			$sent = $this->functions->send_email ( $to, $temp_id, $search_arr );
		    if ( $sent ) {
    			$response			= array (
    				'success'		=> 1,
    				'msg'			=> 'Message sent successfully.',
    				'http_status'	=> REST_Controller::HTTP_OK
    			);
		    }
			
	    }
	    $this->output ( $response );
	}
	
	public function upgrade_subscription_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
		    $this->form_validation->set_rules ( 'tx_id', 'Transaction ID', 'trim|required' );
			$this->form_validation->set_rules ( 'package_name', 'Package Name', 'trim|required' );
			$this->form_validation->set_rules ( 'source', 'Source', 'trim|required' );
			
			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				    = array (
					'success'			    => 0,
					'error'				    => $this->get_validation_error ( ),
					'http_status'		    => REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
				
				$data					    = array (
				    'user_id' 			    => $current_user_id,
				    'tx_id' 	            => $this->_args['tx_id'],
				    'source' 			    => $this->_args['source'],
					'package_name'		    => $this->_args['package_name']
				);
				
				if ( isset ( $this->_args['data'] ) ) {
    			    $data['data']	= $this->_args['data'];
    		    }
				
				$this->functions->add_subscription ( $data );
				
				$subscription = $this->functions->get_subscription ( $current_user_id );
				$response			        = array (
					'success'		        => 1,
					'msg'			        => 'Upgrade successfully.',
					'subscription'          => $subscription,
					'http_status'	        => REST_Controller::HTTP_OK
				);
			}
		} else {
			$response					    = array (
				'success'				    => 0,
				'error'					    => "Unauthorized.",
				'http_status'			    => REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
	}
	
	public function get_user_subscription_post ( ) {
		$response = array ( );
		$current_user_id	= $this->validate_token ( );
	    if ( ! empty ( $current_user_id ) ) {
	        $user_id	    = $current_user_id;
	    } else if ( isset ( $this->_args['user_id'] ) ) {
	        $user_id        = $this->_args['user_id'];
	    }
	    
	    if ( $user_id > 0 ) {
    		$subscription = $this->functions->get_subscription ( $user_id );
    		$response			= array (
				'success'		=> 1,
				'subscription'  => $subscription,
				'http_status'	=> REST_Controller::HTTP_OK
			);
	    }
		
		$this->output ( $response );
	}
	
	public function delete_subscription_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
			
			$this->functions->delete_subscription ( $current_user_id );
			
			$response			= array (
				'success'		=> 1,
				'msg'			=> 'Deleted successfully.',
				'http_status'	=> REST_Controller::HTTP_OK
			);
			
		} else {
			$response			= array (
				'success'		=> 0,
				'error'			=> "Unauthorized.",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
	}
    
    public function get_theme_colors_post ( ) {
	    
        $packages = $this->user_model->get_theme_colors ( );
        
    	$response			= array (
    		'success'		=> 1,
    		'items'		    => $packages,
    		'http_status'	=> REST_Controller::HTTP_OK
    	);
    	$this->output ( $response );
    }
    
    // Check NFC tag exits and assign to any user
	public function check_nfctag_post ( ) {
		$response = array ( );
		$current_user_id =  $this->validate_token ( );
	    if ( $current_user_id ) {
	        
	        $this->form_validation->set_rules ( 'tag_id', 'Tag ID', 'trim|required' );
	        
			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else if ( $this->user_model->tag_exists ( $this->_args['tag_id'], $current_user_id ) ) {
        		$response				= array (
        			'success'			=> 0,
        		    'msg'               => "Tag ID is already activated from another user please try with another one." ,
        			'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        		);
    		} else {
    		    $tag = $this->user_model->tag_exists ( $this->_args['tag_id'] );
    		    if ( ! empty ( $tag ) && ( $tag['account_id'] > 0 ) ) {
    		        $code = 1;
    		        $msg = 'Account ID already exists.';
    		    } else {
    		        $code = 2;
    		        $msg = 'Account ID empty.';
    		    }
    		    $response				= array (
					'success'			=> 1,
					'code'              => $code,
					'msg'               => $msg,
					'http_status'		=> REST_Controller::HTTP_OK
				);
    		}
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		$this->output ( $response );
	}
	
	// Save user apps clicks for analytics 
	public function save_app_clicks_post ( ) {
	    
	    $response	= array ( );

        $this->form_validation->set_rules ( 'app_id', 'App ID', 'trim|required' );

		if ( $this->form_validation->run ( ) === FALSE ) {
			$response				= array (
				'success'			=> 0,
				'msg'				=> $this->get_validation_error ( ),
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
		} else {
	        
	        $app = $this->user_model->get_app_by_id ( $this->_args['app_id'] );
    	    if ( ! empty ( $app ) ) {
    			$data		        = array (
    			    'app_id'	    => $app['id'],
    			    'user_id'	    => $app['user_id'],
    				'account_id'	=> $app['account_id'],
    				'slug'	        => $app['slug']
    			);
    			
    			$id	= $this->user_model->save_app_clicks ( $data );
    			
    			if ( $id > 0 ) {
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Saved successfully.',
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
    			} else {
    			    $response				= array (
        				'success'			=> 0,
        				'msg'				=> "Something went wrong.",
        				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        			);
    			}
	        } else {
	            $response				= array (
    				'success'			=> 0,
    				'msg'				=> "App not found.",
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
	        }
			
		}

		$this->output ( $response );
	    
	}
	
	public function save_advertisement_post ( ) {
	
		$response	= array ( );
		$current_user_id =  $this->validate_token ( );
		
		if ( $current_user_id ) {
		    
    		$subscription = $this->functions->get_subscription ( $current_user_id );
		
    		$this->form_validation->set_rules ( 'title', 'Title', 'trim|required' );
    		$this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
    		$this->form_validation->set_rules ( 'description', 'Description', 'trim|required' );
    		$this->form_validation->set_rules ( 'tx_id', 'Payment', 'trim|required' );
    	
    		if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else if ( empty ( $subscription ) ) {
    		    $response					= array (
    				'success'				=> 0,
    				'msg'                   => "Subscription is required.",
    				'http_status'			=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else {
             
    		    $save_advertisement	= array (
    		        'user_id'	=> $current_user_id,
    			    'title'	    => $this->_args['title'],
    			    'tx_id'	    => $this->_args['tx_id']
    			);
    			if ( isset ( $this->_args['id'] ) ) {
    			    $save_advertisement['id'] = $this->_args['id'];
    			}
    			if ( isset ( $this->_args['description'] ) ) {
    			    $save_advertisement['description'] = $this->_args['description'];
    			}
    			if ( isset ( $this->_args['email'] ) ) {
    			    $save_advertisement['email'] = $this->_args['email'];
    			}
    			if ( isset ( $this->_args['phone'] ) ) {
    			    $save_advertisement['phone'] = $this->_args['phone'];
    			}
    			if ( isset ( $this->_args['link'] ) ) {
    			    $save_advertisement['link'] = $this->_args['link'];
    			}
    			
    			if ( isset ( $_FILES['photo'] ) && ! empty ( $_FILES['photo']['name'] ) ) {
        			$res = $this->upload_file_on_server ( $current_user_id, 'file', 'photo' );
        			$save_advertisement['photo']	= $res['file_name'];
        	    }
    			
        	    $advertisement_id = $this->user_model->save_advertisement ( $save_advertisement );
        	    
    			if ( $advertisement_id > 0 ) {
        			$response				= array (
        				'success'			=> 1,
        				'msg'               => 'Saved Successfully.',
        				'http_status'		=> REST_Controller::HTTP_OK
        			);
    			} else {
    			    $response				= array (
        				'success'			=> 0,
        				'msg'               => 'Something went wrong.',
        				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
        			);
    			}
        	
    		}
    		
		} else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	}
	
	public function delete_advertisement_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
		    $this->form_validation->set_rules ( 'id', 'ID', 'trim|required' );

			if ( $this->form_validation->run ( ) === FALSE ) {
				$response				= array (
					'success'			=> 0,
					'msg'				=> $this->get_validation_error ( ),
					'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
				);
			} else {
			    $id = $this->_args['id'];
    			$this->user_model->delete_advertisement ( $id );
        		$response				= array (
        			'success'			=> 1,
        			'msg'               => 'Deleted successfully.',
        			'http_status'		=> REST_Controller::HTTP_OK
        		);
			}
		} else {
			$response				= array (
				'success'			=> 0,
				'msg'				=> 'Unauthorized.',
				'http_status'		=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
	
		$this->output ( $response );
	}
	
	public function get_advertisement_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
		    
		    $this->form_validation->set_rules ( 'id', 'ID', 'trim|required' );
    	
    		if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else {
			
    			$item = $this->user_model->get_advertisement ( $this->_args['id'] );
    			
    			$response			= array (
    				'success'		=> 1,
    				'item'          => $item,
    				'http_status'	=> REST_Controller::HTTP_OK
    			);
    		}
			
		} else {
			$response			= array (
				'success'		=> 0,
				'error'			=> "Unauthorized.",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
	}
	
	public function get_user_advertisements_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
			
			$items = $this->user_model->get_user_advertisements ( $current_user_id );
			
			$response			= array (
				'success'		=> 1,
				'items'         => $items,
				'http_status'	=> REST_Controller::HTTP_OK
			);
			
		} else {
			$response			= array (
				'success'		=> 0,
				'error'			=> "Unauthorized.",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
	}
	
	public function get_all_advertisements_post ( ) {
		$response			= array ( );
		$current_user_id	= $this->validate_token ( );
		
		if ( $current_user_id ) {
			
			$args = array();
            
            if ( isset ( $this->_args['limit'] ) ) {
                $args['limit']	= $this->_args['limit'];
            } else {
                $args['limit']	= 10;
            }

    	    $current_page	= ( isset ( $this->_args['page'] ) && ! empty( $this->_args['page'] ) ) ? $this->_args['page'] : 1;
    	    if ( $args['limit'] > 0 ) {
    		    $args['offset']	= ( $current_page - 1 ) * $args['limit'];
    	    }
    	    
    	    $items          = $this->user_model->get_all_advertisements ( $args );
    	    
    	    $args['count']	= true;
    		$total_items	= $this->user_model->get_all_advertisements ( $args );
    	
    		if ( ! empty ( $total_items ) ) {
    			$total_items	= $total_items['count'];
    		} else {
    			$total_items	= 0;
    		}
			
    	    $response				= array (
    			'success'			=> 1,
    			'msg'				=> 'Success.',
    			'items'				=> $items,
    			'total_items'       => ( int ) $total_items, 
    			'current_page'      => ( int ) $current_page, 
    			'http_status'		=> REST_Controller::HTTP_OK
    		);
			
		} else {
			$response			= array (
				'success'		=> 0,
				'error'			=> "Unauthorized.",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}
		
		$this->output ( $response );
	}
	
	public function get_app_click_count_post ( ) {
	    
	    $response	= array ( );
	    $current_user_id	= $this->validate_token ( );
	    
	    if ( $current_user_id ) {
	        
			$items	= $this->user_model->get_app_clicks ( $current_user_id );
			
			$response				    = array (
				'success'			    => 1,
				'app_count'             => $this->user_model->get_total_apps ( $current_user_id ),
				'app_click_count'       => $this->user_model->get_total_app_clicks ( $current_user_id ),
				'account_tap_count'     => $this->user_model->get_account_tap_count ( $current_user_id ),
				'device_tap_count'      => $this->user_model->get_device_tap_count ( $current_user_id ),
				'new_device_tap_count'  => $this->user_model->get_device_tap_count ( $current_user_id, false, true ),
				'items'                 => $items,
				'http_status'		    => REST_Controller::HTTP_OK
			);
				
	    } else {
			$response			= array (
				'success'		=> 0,
				'msg'			=> "Unauthorized",
				'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
			);
		}

		$this->output ( $response );
	    
	}
	
    // Save user account tap for analytics 
	public function save_account_tap_post ( ) {
	    $response	= array ( );
        $this->form_validation->set_rules ( 'user_id', 'User ID', 'trim|required' );
        $this->form_validation->set_rules ( 'account_id', 'Account ID', 'trim|required' );
	    $this->form_validation->set_rules ( 'through', 'Through', 'trim|required' );
		if ( $this->form_validation->run ( ) === FALSE ) {
			$response				= array (
				'success'			=> 0,
				'msg'				=> $this->get_validation_error ( ),
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
		} else {
			$data		        = array (
				'user_id'	    => $this->_args['user_id'],
				'account_id'	=> $this->_args['account_id'],
				'through'	    => $this->_args['through']
			);
			$save	= $this->user_model->save_account_tap ( $data );
			if ( $save ) {
				$response				= array (
					'success'			=> 1,
					'msg'               => 'Saved successfully.',
					'http_status'		=> REST_Controller::HTTP_OK
				);
			}
		}
		$this->output ( $response );
	}
	
	// Save user account tap for analytics 
	public function save_device_tap_post ( ) {
	    $response	= array ( );
        $this->form_validation->set_rules ( 'user_id', 'User ID', 'trim|required' );
        $this->form_validation->set_rules ( 'tag_id', 'Tag ID', 'trim|required' );
	    $this->form_validation->set_rules ( 'through', 'Through', 'trim|required' );
		if ( $this->form_validation->run ( ) === FALSE ) {
			$response				= array (
				'success'			=> 0,
				'msg'				=> $this->get_validation_error ( ),
				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
			);
		} else {
			$data		        = array (
				'user_id'	    => $this->_args['user_id'],
				'tag_id'	    => $this->_args['tag_id'],
				'through'	    => $this->_args['through']
			);
			$save	= $this->user_model->save_device_tap ( $data );
			if ( $save ) {
				$response				= array (
					'success'			=> 1,
					'msg'               => 'Saved successfully.',
					'http_status'		=> REST_Controller::HTTP_OK
				);
			}
		}
		$this->output ( $response );
	}
	
	public function password_check( $pass ) {
	   // Min 1 uppercase, lowercase, number, special character Min 8 characters and Max 30 characters.
       if ( preg_match( '/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[#$@!%&*?])[A-Za-z\d#$@!%&*?]{8,30}$/', $pass ) ) {
         return TRUE;
       }
       $this->form_validation->set_message ( 'password_check', 'Password should contain min 1 uppercase, 1 lowercase, 1 number, 1 special character, min 8 characters and max 30 characters.' );
       return FALSE;
    }
    
    // add connect category 
	public function add_connect_cat_post ( ) {
    	$response = array ( );
    	$current_user_id =  $this->validate_token ( );
    	if ( $current_user_id ) {
    	     $this->form_validation->set_rules ( 'name', 'Name', 'trim|required' );
    	     
    	     if ( $this->form_validation->run ( ) === FALSE ) {
    			$response				= array (
    				'success'			=> 0,
    				'msg'				=> $this->get_validation_error ( ),
    				'http_status'		=> REST_Controller::HTTP_BAD_REQUEST
    			);
    		} else {
    			$data		        = array (
    				'name'	    => $this->_args['name']
    			);
    			$save	= $this->user_model->save_connect_cat ( $data );
    			if ( $save ) {
    				$response				= array (
    					'success'			=> 1,
    					'msg'               => 'Saved successfully.',
    					'http_status'		=> REST_Controller::HTTP_OK
    				);
    			}
            }

    	} else {
    		$response			= array (
    			'success'		=> 0,
    			'msg'			=> "Unauthorized",
    			'http_status'	=> REST_Controller::HTTP_UNAUTHORIZED
    		);
    	}
    	$this->output ( $response );
    }
    
    // add connect relation category 
    public function add_connect_relation_post() {
        $response = array();
        $current_user_id = $this->validate_token();
    
        if ($current_user_id) {
            
            $this->form_validation->set_rules('connect_ids', 'Connect IDs', 'trim|required');
            $this->form_validation->set_rules('cat_id', 'Cat ID', 'trim|required');
    
            if ($this->form_validation->run() === FALSE) {
                $response = array(
                    'success'       => 0,
                    'msg'           => $this->get_validation_error(),
                    'http_status'   => REST_Controller::HTTP_BAD_REQUEST
                );
            } else {
                $connect_ids_str = $this->_args['connect_ids']; 
                $cat_id = $this->_args['cat_id']; 
    
                
                $connect_ids = explode(',', $connect_ids_str);
    
                
                if (empty($connect_ids)) {
                    $response = array(
                        'success'       => 0,
                        'msg'           => 'Connect IDs must be provided and must be an array.',
                        'http_status'   => REST_Controller::HTTP_BAD_REQUEST
                    );
                } else {
                   
                    foreach ($connect_ids as $connect_id) {
                        
                        $connect_id = trim($connect_id);
    
                        $data = array(
                            'connect_id' => $connect_id,
                            'cat_id'     => $cat_id
                        );
                        
                        $connect = $this->user_model->save_connect_relation($data);
    
                        if (!$connect) {
                            $response = array(
                                'success'       => 0,
                                'msg'           => 'Failed to save for some connect IDs.',
                                'http_status'   => REST_Controller::HTTP_INTERNAL_SERVER_ERROR
                            );
                            break; 
                        }
                    }
    
                    if (!isset($response['success'])) {
                        $response = array(
                            'success'       => 1,
                            'msg'           => 'Saved successfully.',
                            'http_status'   => REST_Controller::HTTP_OK
                        );
                    }
                }
            }
        } else {
            $response = array(
                'success'       => 0,
                'msg'           => 'Unauthorized',
                'http_status'   => REST_Controller::HTTP_UNAUTHORIZED
            );
        }
    
        $this->output($response);
    }

	
}
?>