<?php

defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

require APPPATH . '/libraries/REST_Controller.php';

require_once APPPATH .'third_party/vcard/Behat-Transliterator/Transliterator.php';
require_once APPPATH .'third_party/vcard/jeroendesloovere-vcard/VCard.php';

class Base extends REST_Controller {
    
    public function __construct ( ) {
		
		parent::__construct ( );
		
		$this->load->model ( 'user_model' );
		$this->load->library ( 'functions' );
	    $this->load->helper( 'url' );
	    
	}
	
	public function generate_profile_qrcode ( $user_id, $account_id ) {
	    $qrcode     = false;
	    $account    = $this->user_model->get_account ( $account_id );
	    $upload_dir = $this->config->item ( 'upload_dir_path' ).'user_qrcode/'; 
	    if ( ! empty ( $account ) ) {
	        
	        if ( empty ( $account['profile_id'] ) ) {
	            
        	    $qrcode             = uniqid ( 'p' . $user_id . 'o' . $account_id . 'd' );
        		
                $save = array (
                    'user_id'       => $user_id,
                    'account_id'    => $account_id,
                    'profile_id'    => $qrcode
                );
                $this->user_model->save_account ( $save );
	        } else {
	            $qrcode = $account['profile_id'];
	        }
	        
	        $profile_url        = base_url ( 'profile/' . $qrcode );
    		$this->load->library('ciqrcode');
            $params['data']     = $profile_url;
            $params['level']    = 'H';
            $params['size']     = 8;
            $params['white']	= array( 0, 0, 0 );
            $params['savename'] = $upload_dir . $qrcode . '.png';
            $this->ciqrcode->generate ( $params );
	        
            /*if ( ! empty ( $account['photo'] ) ) {
                
                $filepath       = $upload_dir . $qrcode . '.png'; 
                $QR             = imagecreatefrompng( $filepath );
                $logo           = imagecreatefromstring( file_get_contents( base_url ( 'public/uploads/user_images/thumb/' . $account['photo'] ) ) );
                
                // Add white background in logo
                // imagecolortransparent($logo , imagecolorallocatealpha($logo , 0, 0, 0, 127));
                // imagealphablending($logo , false);
                // imagesavealpha($logo , true);
                
                $QR_width       = imagesx( $QR );
                $QR_height      = imagesy( $QR );
                
                $logo_width     = imagesx( $logo );
                $logo_height    = imagesy( $logo );
                
                // Scale logo to fit in the QR Code
                $logo_qr_width  = $QR_width / 3;
                $scale          = $logo_width / $logo_qr_width;
                $logo_qr_height = $logo_height / $scale;
                
                imagecopyresampled( $QR, $logo, $QR_width / 3, $QR_height / 3, 0, 0, $logo_qr_width, $logo_qr_height, $logo_width, $logo_height );
                
                // Save QR code again, but with logo on it
                imagepng ( $QR, $filepath );
                
            } */
        } 
        return $qrcode;
       
	}
	
	public function validate_token ( ) {
		if ( array_key_exists ( 'Token', $this->_head_args ) && ! empty ( $this->_head_args['Token'] ) ) {
			return $this->user_model->validate_token ( $this->_head_args['Token'] );
		}
		return false;
	}
	
	public function get_validation_error ( ) {
		$return = false;
		if ( $this->form_validation->run ( ) === FALSE ) {
			$errors			= $this->form_validation->error_array ( );
			if ( ! empty ( $errors ) ) {
				foreach ( $errors as $field => $error ) {
					$return	=  $error;
					break;
				}
			}
		}
		return $return;
	}
	
	function output ( $response, $http_status = REST_Controller::HTTP_OK ) {
		$this->response ( $response, $http_status );
	}
	
}