<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class Cron extends CI_Controller {
    
	public function __construct () {
	    
		parent::__construct ();
		$this->load->library ( 'functions' );
		
	}
	
    public function check_user_subscription_android () {
        $data = file_get_contents("php://input");
        if ( ! empty ( $data ) ) {
            $res1 = json_decode( $data );
            if ( isset ( $res1->message->data ) ) {
                $res2 = json_decode( base64_decode( $res1->message->data ) );
                $cancel_types = array ( 12, 13 ); // don't delete entry in case of 3
                if ( isset ( $res2->subscriptionNotification ) ) {
                    $res = $res2->subscriptionNotification;
                    if ( in_array ( $res->notificationType, $cancel_types ) ) {
                        $purchaseToken = $res->purchaseToken;
                        $qry = $this->db->select ( "user_id" )->from ( 'user_subscription' )->where ( 'tx_id', $purchaseToken )->get ();
                        if ( $qry->num_rows() > 0 ) {
                            $row        = $qry->row_array();
                			$user_id    = $row['user_id'];
                			$this->db->where ( 'id', $user_id );
    		                $this->db->update ( 'users', array ( 'token' => '' ) );
    		                
                            $this->db->where ( 'user_id', $user_id );
    		                $this->db->delete ( 'user_subscription' );
                        }
                    }
                }
            }
        }
    }
    
    public function ios_subscription () {
        $data = file_get_contents("php://input");
        if ( ! empty ( $data ) ) {
            $event = json_decode( $data );
            $cancel_types = array ( 'CANCEL', 'DID_FAIL_TO_RENEW', 'REFUND', 'REVOKE' ); // DID_CHANGE_RENEWAL_STATUS Renewal case
            if ( in_array ( $event->notification_type, $cancel_types ) ) {
                $purchaseToken = $event->original_transaction_id;
                $qry = $this->db->select ( "user_id" )->from ( 'user_subscription' )->where ( 'tx_id', $purchaseToken )->get ();
                if ( $qry->num_rows() > 0 ) {
                    $row        = $qry->row_array();
        			$user_id    = $row['user_id'];
        			$this->db->where ( 'id', $user_id );
	                $this->db->update ( 'users', array ( 'token' => '' ) );
	                
                    $this->db->where ( 'user_id', $user_id );
	                $this->db->delete ( 'user_subscription' );
                }
            }
        }
        
    }
    
    
    public function generate_profiles_qrcode ( ) {
	    
	    $upload_dir = $this->config->item ( 'upload_dir_path' ).'user_qrcode/'; 
	    
	    $this->db->select ( "profile_id" )->from ( 'accounts' );
	    $limit = 1; $offset = 0;
	    $this->db->limit ( $limit, $offset );
	    $qry = $this->db->get ();
        if ( $qry->num_rows() > 0 ) {
            $result     = $qry->result_array();
            foreach ( $result as $row ) {
                $qrcode = $row['profile_id'];
        	    if ( ! empty ( $qrcode ) ) {
        	        echo $qrcode.'<br>';
            		$this->load->library('ciqrcode');
                    $params['data']     = base_url ( 'profile/' . $qrcode );
                    $params['level']    = 'H';
                    $params['size']     = 8;
                    $params['white']	= array( 0, 0, 0 );
                    $params['savename'] = $upload_dir . $qrcode . '.png';
                    $this->ciqrcode->generate ( $params );
                } 
            }
        }
       
	}
	
}