<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class Index extends CI_Controller {
	public function __construct () {
		parent::__construct ();
		$this->load->library ( 'functions' );
		$this->load->library ( 'form_validation' );
	}
	
	public function index () {
		$data	= array();
		$this->load->view ( 'index', $data );
	}
	
	public function send_contact_email () {
	    $response = array ( );
	    $this->form_validation->set_rules ( 'name', 'Name', 'trim|required' );   
        $this->form_validation->set_rules ( 'email', 'Email', 'trim|required|valid_email' );
        $this->form_validation->set_rules ( 'message', 'Message', 'trim|required' );
        
		if ( $this->form_validation->run ( ) === FALSE ) {
		    $errors			= $this->form_validation->error_array ( );
			$response		= array (
				'success'	=> 0,
				'msg'		=> $errors
			);
		} else {
	        $message = '';
	        
	        $name       = $this->input->post('name');
	        $email      = $this->input->post('email');
	        $msg        = $this->input->post('message');
	        
	        $message .= 'Name: '. $name . '<br><br>';
	        $message .= 'Email: '. $email . '<br><br>';
	        
			$message .= $msg;
 
			$search_arr			= array(
				'{content}'		=> nl2br ( $message )
			);
				
			$temp_id	    = 2;
			$admin_email_settings = $this->config->item ( 'admin_email_settings' );
			$to = $admin_email_settings['admin_email'];
			$sent = $this->functions->send_email ( $to, $temp_id, $search_arr );
		    if ( $sent ) {
    			$response			= array (
    				'success'		=> 1,
    				'msg'			=> 'Message sent successfully.'
    			);
		    }
			
	    }
	    echo json_encode ( $response );
	}
}
?>