<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class Dashboard extends Admin_Controller {
	public function __construct () {
		parent::__construct ();
		$this->load->model ( 'admin/dashboard_model', 'dashboard_model' );
		$this->load->library ( 'pagination' );
		$this->load->library ( 'functions' );
	}
    
    // Dashboard index function
	public function index () {
	    
		$data['all_users']          = $this->dashboard_model->get_all_users_count();
		$data['active_users']	    = $this->dashboard_model->get_active_users_count ();
		$data['inactive_users']	    = $this->dashboard_model->get_deactive_users_count ();
		$data['devices_users']		= $this->dashboard_model->get_devices_users_count ();
		$data['title']			    = 'Dashboard';
		$data['view']			    = 'admin/dashboard/index';
		$this->load->view ( 'admin/layout', $data );
	}
    
    // Change admin password function
	function change_admin_pass () {
	    $updated = false;
	    $password = $this->input->post ( 'password' );
	    if ( ! empty ( $password ) ) {
	        $data['password'] = md5 ( $password );
	        $updated =  $this->dashboard_model->update_admin ( $data );
	    }
	    echo $updated;
	    exit;
	}
	
}
?>