<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class Device_management extends Admin_Controller {
	public function __construct () {
		parent::__construct ();
		
		$this->load->model ( 'admin/dashboard_model', 'dashboard_model' );
		$this->load->library ( 'pagination' );
		$this->load->library ( 'functions' );
	}
	
    //  Smart object / Devices listing
	public function index () {
	    	
		if ( $this->input->post ( 'action' ) ) {
		    $tag_id = $this->input->post ( 'delete_id' );
		    $action = $this->input->post ( 'action' );
		    if ( ( $action == 'delete' ) && ( $tag_id > 0 ) ) {
    	        $this->dashboard_model->delete_device ( $tag_id );
    	        $this->session->set_flashdata ( 'success', 'Deleted Successfully.' );
		    }
		}
	    
	    $params = $this->input->get ();
		$arg = array ();
		
		if( isset ( $params ) ) {
			$arg = $params;
		}
		
		if( isset( $params['show_records'] ) && $params['show_records'] > 0 ) {
			$per_page_record = $params['show_records'];
		} else {
			$per_page_record = 10;
		}
		
		$page = ( $this->uri->segment ( 4 ) ) ? $this->uri->segment ( 4 ) : 0;
		
		if( $page > 0 ) {
			$page = ( $page - 1 ) * $per_page_record;
		}
	
		$count = $this->dashboard_model->get_devices ( array ( 'count' => true ) + $arg );
	
		$url = base_url ( 'admin/device_management/index' );

		$config = $this->functions->pagination_config ( $url, $count, $per_page_record );
		$config['use_page_numbers'] = TRUE;		
		$this->pagination->initialize ( $config );
	
		$arg['limit'] =  $per_page_record;
		$arg['offset'] =  $page;
	
		$devices = $this->dashboard_model->get_devices ( $arg );
		
		$data['offset']  = $page;
		$data['per_page_limit']  = $page + $per_page_record;
		$data['total_tags']  = $count;
	    $data['devices']  = $devices;
	    
		$data['title']  = 'Device Management';
		$data['view']   = 'admin/device_management/index';
		$this->load->view ( 'admin/layout', $data );
	}
	
	// Add new device
	public function add_device () {
		$data = array ();
		
		$tag_id     = $this->input->post ( 'device_id' );
		$tag_name   = $this->input->post ( 'device_name' );
		if ( ! empty ( $tag_id ) && ! empty ( $tag_name ) ) {
	
			$data = array (
			    'tag_id'		=> $tag_id,
				'tag_name'	    => $tag_name
			);
			
			$id = $this->dashboard_model->save_device ( $data );
			if ( $id > 0 ) {
			    $this->session->set_flashdata ( 'success', '<strong>' . $tag_id . '</strong> has been added successfully.' );
		    }
			
		}
		
		redirect ( 'admin/device_management/index' );
	}
	
	// Export all devices as a csv format
	public function export_devices () {
	    
        $devices = $this->dashboard_model->get_new_devices();
        
        if ( ! empty ( $devices ) ) {
            
        	$filename = time( ) . '.csv';
        	
        	header ( 'Content-Description: File Transfer;'); 
        	header ( 'Content-Disposition: attachment; filename=' . $filename );
        	header ( 'Content-Type: application/csv;' );
        
        	$file = fopen ( 'php://output', 'w' );
        
        	$header = array ( 'Device ID', 'Device Name', 'QR Code' );
        
        	fputcsv ( $file, $header );
        	
        	foreach ( $devices as $device ) {
        		
        		$row = array ( $device['tag_id'], $device['tag_name'] , base_url ( 'public/uploads/user_qrcode/' . $device['profile_id'] . '.png' ) );
        		
        		fputcsv ( $file, $row );
        	}
        	
        	fclose ( $file );
        	exit; 
        	
        } else {
            $this->session->set_flashdata ( 'info', 'No new devices found.' );
        }
    	redirect ( 'admin/device_management/index' );

	}
	
	// Import devices in bulk from csv file
	public function import_devices () {
	    
	    if ( isset ( $_FILES["file_name"] ) && ! empty ( $_FILES["file_name"] ) ) {
            
            $file_name = $_FILES["file_name"]["tmp_name"];
            
            $file = fopen( $file_name, "r" );
            $flag = true;
            while ( ( $data = fgetcsv( $file, 1000, "," ) ) !== FALSE ) {
                if ( $flag ) { $flag = false; continue; }
                
                $tag_id     = $data[0];
                $tag_name   = $data[1];
                $data = array (
    			    'tag_id'		=> $tag_id,
    				'tag_name'	    => $tag_name
    			);
    			
    			$id = $this->dashboard_model->save_device ( $data );
            }
            if ( $id > 0 ) {
			    $this->session->set_flashdata ( 'success', 'Device has been imported successfully.' );
		    }
        } else {
            $this->session->set_flashdata ( 'error', 'No file is selected.' );
        }
    	redirect ( 'admin/device_management/index' );

	}
	
	//  Device types listing
	public function types () {
	    	
		if ( $this->input->post ( 'action' ) ) {
		    $tag_id = $this->input->post ( 'delete_id' );
		    $action = $this->input->post ( 'action' );
		    if ( ( $action == 'delete' ) && ( $tag_id > 0 ) ) {
    	        $this->dashboard_model->delete_device_type ( $tag_id );
    	        $this->session->set_flashdata ( 'success', 'Deleted Successfully.' );
		    }
		}
	    
	    $params = $this->input->get ();
		$arg = array ();
		
		if( isset ( $params ) ) {
			$arg = $params;
		}
		
		if( isset( $params['show_records'] ) && $params['show_records'] > 0 ) {
			$per_page_record = $params['show_records'];
		} else {
			$per_page_record = 10;
		}
		
		$page = ( $this->uri->segment ( 4 ) ) ? $this->uri->segment ( 4 ) : 0;
		
		if( $page > 0 ) {
			$page = ( $page - 1 ) * $per_page_record;
		}
	
		$count = $this->dashboard_model->get_device_types ( array ( 'count' => true ) + $arg );
	
		$url = base_url ( 'admin/device_management/types' );

		$config = $this->functions->pagination_config ( $url, $count, $per_page_record );
		$config['use_page_numbers'] = TRUE;		
		$this->pagination->initialize ( $config );
	
		$arg['limit'] =  $per_page_record;
		$arg['offset'] =  $page;
	
		$devices = $this->dashboard_model->get_device_types ( $arg );
		
		$data['offset']  = $page;
		$data['per_page_limit']  = $page + $per_page_record;
		$data['total_tags']  = $count;
	    $data['devices']  = $devices;
	    
		$data['title']  = 'Device Type Management';
		$data['view']   = 'admin/device_management/types';
		$this->load->view ( 'admin/layout', $data );
	}
	
		// Add new device
	public function add_device_type () {
	
		$name       = $this->input->post ( 'name' );
		$id         = $this->input->post ( 'device_type_id' );
		
		if ( isset ( $_FILES['file_name'] ) && ! empty ( $_FILES['file_name'] ) ) {
			$this->load->library ( 'upload' );
			$upload_dir			= $this->config->item ( 'upload_dir_path' ).'user_files/';
			
			$config				= array (
				'upload_path'	=> $upload_dir,
				'allowed_types'	=> 'jpg|jpeg|png|gif',
				'file_name'		=>  time ( ),
				'overwrite'		=> false
			);
			$this->upload->initialize ( $config );
		
			if ( $this->upload->do_upload ( 'file_name' ) ) {
				$uploaded		    = $this->upload->data ( );
				$save_data = array ( 'image' => $uploaded['file_name'] );
			}
		
		}
		
		if ( ! empty ( $name ) ) {
	        if ( $id > 0 ) {
	            $save_data['id'] = $id;
	        }
			$save_data['name'] = $name;
			
			$id = $this->dashboard_model->save_device_type ( $save_data );
			if ( $id > 0 ) {
			    $this->session->set_flashdata ( 'success', 'Added successfully.' );
		    }
			
		}
		
		redirect ( 'admin/device_management/types' );
	}
	

}
?>