<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class Themes extends Admin_Controller {
	public function __construct () {
		parent::__construct ();
		
		$this->load->model ( 'admin/dashboard_model', 'dashboard_model' );
		$this->load->library ( 'pagination' );
		$this->load->library ( 'functions' );
	}
    
    // Theme lising page
	public function index () {
	    
	    if ( $this->input->post ( 'action' ) ) {
		    $theme_id = $this->input->post ( 'delete_id' );
		    $action = $this->input->post ( 'action' );
		    if ( ( $action == 'delete' ) && ( $theme_id > 0 ) ) {
    	        $this->dashboard_model->delete_theme ( $theme_id );
    	        $this->session->set_flashdata ( 'success', 'Deleted Successfully.' );
		    }
		}
	    
	    $params = $this->input->get ();
		$arg = array ();
		$packages = array ();
		
		if( isset ( $params ) ) {
			$arg = $params;
		}
		
		if( isset( $params['show_records'] ) && $params['show_records'] > 0 ) {
			$per_page_record = $params['show_records'];
		} else {
			$per_page_record = 10;
		}
		
		$page = ( $this->uri->segment ( 4 ) ) ? $this->uri->segment ( 4 ) : 0;
		
		if( $page > 0 ) {
			$page = ( $page - 1 ) * $per_page_record;
		}
	
		$count = $this->dashboard_model->get_themes ( array ( 'count' => true ) + $arg );
	
		$url = base_url ( 'admin/themes/index' );

		$config = $this->functions->pagination_config ( $url, $count, $per_page_record );
		$config['use_page_numbers'] = TRUE;		
		$this->pagination->initialize ( $config );
	
		$arg['limit'] =  $per_page_record;
		$arg['offset'] =  $page;
	
		$themes = $this->dashboard_model->get_themes ( $arg );
		
		$data['offset']  = $page;
		$data['per_page_limit']  = $page + $per_page_record;
		$data['total_themes']  = $count;
		$data['themes']  = $themes;
	    
		$data['title']  = 'Dashboard';
		$data['view']   = 'admin/themes/index';
		$this->load->view ( 'admin/layout', $data );
	}
	
	// Save themes details
	public function save () {
		$data = array ();
		
		$id     = $this->input->post ( 'theme_id' );
		$name   = $this->input->post ( 'theme_name' );
		$color  = $this->input->post ( 'theme_color' );
		
		if ( ! empty ( $name ) && ! empty ( $color ) ) {
	
			$data = array (
			    'id'		=> $id,
				'name'	    => $name,
				'color'		=> $color
			);
			
			$id = $this->dashboard_model->save_theme ( $data );

			if ( $id ) {
			    if ( $this->input->post ( 'theme_id' ) > 0 ) {
				    $this->session->set_flashdata ( 'success', '<strong>'.$name.'</strong> has been updated successfully.' );
			    } else {
			        $this->session->set_flashdata ( 'success', '<strong>'.$name.'</strong> has been created successfully.' );
			    }
				
			}
		}
		
		redirect ( 'admin/themes/index' );
	}

}
?>