<?php
defined ( 'BASEPATH' ) OR exit ( 'No direct script access allowed' );

class User_management extends Admin_Controller {
	public function __construct () {
		parent::__construct ();
		
		$this->load->model ( 'admin/dashboard_model', 'dashboard_model' );
		$this->load->library ( 'pagination' );
		$this->load->library ( 'functions' );
	}
    
    // User listing page
	public function index () {
	    
	    // Block/unblock script	
		if ( $this->input->post ( 'action' ) ) {
		    $user_id =$this->input->post ( 'user_id' );
		    $action =$this->input->post ( 'action' );
		    if ( $action == 'user_unblock' ) {
		        $status = 1;
		        $msg = 'Unblocked Successfully.';
		    } else {
		        $status = 0;
		        $msg = 'Blocked Successfully.';
		    }
		    if ( $user_id > 0 ) {
		        $update_user        = array (
		            'id'            => $user_id,
		            'user_status'   => $status,
		        );
    	        $this->dashboard_model->update_user ( $update_user );
    	        $this->session->set_flashdata ( 'success', $msg );
    	    }

		}
	    
	    $params = $this->input->get ();
		$arg = array ();
		$users = array ();
		
		if( isset ( $params ) ) {
			$arg = $params;
		}
		
		if( isset( $params['show_records'] ) && $params['show_records'] > 0 ) {
			$per_page_record = $params['show_records'];
		} else {
			$per_page_record = 10;
		}
		
		$page = ( $this->uri->segment ( 4 ) ) ? $this->uri->segment ( 4 ) : 0;
		
		if( $page > 0 ) {
			$page = ( $page - 1 ) * $per_page_record;
		}
	
		$count = $this->dashboard_model->get_users ( array ( 'count' => true ) + $arg );
	
		$url = base_url ( 'admin/user_management/index' );

		$config = $this->functions->pagination_config ( $url, $count, $per_page_record );
		$config['use_page_numbers'] = TRUE;		
		$this->pagination->initialize ( $config );
	
		$arg['limit'] =  $per_page_record;
		$arg['offset'] =  $page;
	
		$users = $this->dashboard_model->get_users ( $arg );
		if ( ! empty ( $users ) ) {
		    foreach ( $users as $k => $user ) {
		        $subscription = $this->functions->get_subscription ( $user['id'] );
		        if ( ! empty ( $subscription ) ) {
		            $users[$k]['plan'] = $subscription['package_name'];
		        } else {
		            $users[$k]['plan'] = 'free';
		        }
		        
		    }
		}
		
		$data['offset']  = $page;
		$data['per_page_limit']  = $page + $per_page_record;
		$data['total_users']  = $count;
	    $data['users']  = $users;
		$data['title']  = 'Dashboard';
		$data['view']   = 'admin/user_management/index';
		$this->load->view ( 'admin/layout', $data );
	}
	
	
}
?>