<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

	function active_menu ( $class=false, $method=false ) {
        // Getting CI class instance.
        $CI = get_instance();
        // Getting router class to active.
        $fetch_class    = $CI->router->fetch_class();
        $fetch_method = false;
        if ( $method ) {
            $fetch_method   = $CI->router->fetch_method();
        }
        
        return ( $class == $fetch_class && $method == $fetch_method ) ? 'active' : '';
    }
 
    function  display_response_messages() {
       $CI = get_instance(); 
       if ( $CI->session->flashdata ( 'success' ) || $CI->session->flashdata ( 'error' ) || $CI->session->flashdata ( 'warning' ) || $CI->session->flashdata ( 'info' ) ) { ?>
			<div class="flash-msg">
				<?php if ( $CI->session->flashdata ( 'success' ) ) { ?>
					<div class="alert alert-success fade show" role="alert" id="alertSuccess">
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
						<strong>Success!</strong> <?php echo $CI->session->flashdata ( 'success' ); ?>
					</div>
				<?php } ?>
				
				<?php if ( $CI->session->flashdata ( 'error' ) ) { ?>
					<div class="alert alert-danger fade show" role="alert">
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
						<strong>Error!</strong> <?php echo $CI->session->flashdata ( 'error' ); ?>
					</div>
				<?php } ?>
				
				<?php if ( $CI->session->flashdata ( 'warning' ) ) { ?>
					<div class="alert alert-warning fade show" role="alert">
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
						<strong>Warning!</strong><?php echo $CI->session->flashdata ( 'warning' ); ?>
					</div>
				<?php } ?>
				
				<?php if ( $CI->session->flashdata ( 'info' ) ) { ?>
					<div class="alert alert-info fade show" role="alert">
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
						<strong>Info!</strong> <?php echo $CI->session->flashdata ( 'info' ); ?>
					</div>
				<?php } ?>
			</div>
			<script>
            $(document).ready(function(){
                $(".close").click(function(){
                    $(this).closest('.alert').alert('close');
                });
            });
            </script>
		<?php 
		unset($_SESSION['success']); unset($_SESSION['error']);
		unset($_SESSION['warning']); unset($_SESSION['info']);
		}
        
    }
    
    function sort_url ( $base_url = '', $order_by = '' ) {
		if ( $order_by != '' ) {
			$separator = '?';
			
			if ( strstr ( $base_url, '?' ) !== false ) {
				$separator = '&';
			}

			$order = 'asc';
			if ( isset ( $_GET['order_by'] ) && $_GET['order_by'] == $order_by ) {
				$order = 'desc';
				
				if ( isset ( $_GET['order'] ) && $_GET['order'] == 'desc' ) {
					$order = 'asc';
				}
			}

			$base_url = $base_url . $separator . 'order_by=' . $order_by . '&order=' . $order;
		}

		return $base_url;
	}
	
	function sort_class ( $order_by = '' ) {
		if ( $order_by != '' && isset ( $_GET['order_by'] ) && $_GET['order_by'] == $order_by ) {
			$class = 'asc';
			
			if ( isset ( $_GET['order'] ) && $_GET['order'] == 'desc' ) {
				$class = 'desc';
			}

			return 'sorting_' . $class;
		} else {
		    return 'sorting';
		}
	}
	
	function get_sign ( $link ) {
        if (strstr( $link, '?' ) !== FALSE ) {
            return '&';
        } else {
            return '?';
        }
    }
    
    function count_format ( $value ) {
        if ($value > 999 && $value <= 999999) {
            $result = floor($value / 1000) . ' K';
        } elseif ($value > 999999) {
            $result = floor($value / 1000000) . ' M';
        } else {
            $result = $value;
        }
        return $result;
    }
    
    function phone_format( $phonecode='', $phone='' ) {
        if ( ! empty ( $phone ) ) {
            $phone = (($phonecode)?'+'.$phonecode:'') . ' ' . $phone;
        }
        return $phone;
    }

    function get_user_device () {
        //Detect special conditions devices
        $iPod    = stripos($_SERVER['HTTP_USER_AGENT'],"iPod");
        $iPhone  = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
        $iPad    = stripos($_SERVER['HTTP_USER_AGENT'],"iPad");
        $Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
        $webOS   = stripos($_SERVER['HTTP_USER_AGENT'],"webOS");
        
        //do something with this information
        if( $iPod || $iPhone || $iPad ){
            return 'ios';
        } else if($Android){
            return 'android';
        } else {
            return 'web';
        }
    }

?>