
<?php

	$base_url = base_url ( 'admin/device_management/index' );
	
	if ( ! empty ( $_GET ) ) {
		$query_string = $_GET;
		
		if ( isset ( $query_string['order_by'] ) ) {
			unset ( $query_string['order_by'] );
		}
		
		if ( isset ( $query_string['order'] ) ) {
			unset ( $query_string['order'] );
		}
		
		if ( ! empty ( $query_string ) ) {
			$query_string = http_build_query ( $query_string );
			$base_url = $base_url . '?' . $query_string;
		}
	}
?>

<div class="row">
    <div class="col-md-12 m-b-30">
        <div class="d-block flex-nowrap align-items-center">
            <div class="page-title ">
                <h1 class="title-icon">
                    <i class="fa fa-database"></i><strong>Device Management</strong>
                </h1>
                <div class="invoice-buttons text-right"> 
                    <a href="#" class="btn btn-info export-device" data-toggle="modal" data-target="#import-devices-form-model">Import Devices</a>
                    <a href="<?php echo base_url ( 'admin/device_management/export_devices' ); ?>" class="btn btn-info export-devices">Export Devices</a>
                    <a href="#" class="btn btn-info add-device" data-toggle="modal" data-target="#device-form-model">Add New Device</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Notification -->
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">All Users</h4>
            </div>
            <div class="card-body">
                <div class="datatable-wrapper table-responsive">        
                    <div class="datatable-wrapper table-responsive table-devices">
                        <table class="dataTable display compact table">
                            <thead>
                                <tr>
                                    <th class="<?php echo sort_class ( 'id' ); ?>"><a href="<?php echo sort_url ( $base_url, 'id' ); ?>">S.No.</a></th>
                                    <th class="<?php echo sort_class ( 'tag_name' ); ?>"><a href="<?php echo sort_url ( $base_url, 'tag_name' ); ?>">Name</a></th>
                                    <th class="<?php echo sort_class ( 'tag_id' ); ?>"><a href="<?php echo sort_url ( $base_url, 'tag_id' ); ?>">Tag Number</a></th>
                                    <th class="<?php echo sort_class ( 'email' ); ?>"><a href="<?php echo sort_url ( $base_url, 'email' ); ?>">Email</a></th>
                                    <th>QRCode</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ( ! empty ( $devices ) ) {
                                    $sort_class =  sort_class ( 'id' );
                                    if ( $sort_class == 'sorting_desc') {
                                        $count  = $total_tags-$offset;
                                    } else {
                                        $count  = $offset+1;
                                    }
                				    foreach ( $devices as $key => $device ) {
                				        $tag_id = $device['tag_id'];
                				        $tag_url = "#";
                				        if ( ! empty ( $tag_id ) ) {
            	                            $tag_url = base_url () . 'nfc/' . $tag_id;
                				        }
                				        ?>
                						<tr>
                							<td><?php echo $count; ?></td>
                							<td><?php echo $device['tag_name']; ?></td>
                							<td><a href="<?php echo $tag_url; ?>" target="<?php echo ($tag_url=='#')?'_self':'_blank';?>"/><?php echo $device['tag_id']; ?></a></td>
                							<td><?php echo ($device['email'])?$device['email']:'N/A'; ?></td>
                							<td>
                							    <?php
                							    if ( ! empty ( $device['profile_id'] ) ) { ?>
                							        <a href="<?php echo base_url ( 'public/uploads/user_qrcode/' . $device['profile_id'] . '.png' ); ?>" target="_blank"/><img src="<?php echo base_url ( 'public/uploads/user_qrcode/' . $device['profile_id'] . '.png' ); ?>" /></a>
                						        <?php } else {
                						            echo 'N/A';
                						        } ?>
                						    </td>
                							<td>
                								<button class="btn btn-danger text-white" data-toggle="modal" onclick="delete_device( '<?php echo $device['tag_id']; ?>' );" data-target="#delete">Delete</button>
                							</td>
                						</tr>
                				        <?php
                				        if ( $sort_class == 'sorting_desc') {
                				            $count--;
                				        } else {
                                            $count++;
                                        }
                				    } 
            				    } ?>
            
                            </tbody>
            
                        </table>
                    </div>
        
                	<div class="col-sm-12 col-md-12 d-flex justify-content-between pt-1 pb-4 align-items-center">
                		<div class="dataTables_info" id="datatable_info" role="status" aria-live="polite">
                		    Showing <?php echo (($offset==0)?'1':$offset); ?> to <?php echo (($per_page_limit>$total_tags)?$total_tags:$per_page_limit); ?> of <?php echo $total_tags; ?> entries
                		</div>
                	    <div class="dataTables_paginate paging_simple_numbers">
                		    <?php echo $this->pagination->create_links (); ?>
                		</div>
                	</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function delete_device ( id ) {
        if ( id ) {
            $('#delete_form').attr( 'action', location.href );
            $('#delete_id').val( id );
        }
    }
    function submit_device_form ( ) {
        var name = $('#device_name').val();
        var device_id = $('#device_id').val();
        if( name == ''  ) {
            alert('Please enter device name.');
        } else if( device_id == '' ) {
            alert( 'Please enter device ID.' );
        } else {
            document.getElementById("device-form").submit(); 
        }
    }
    function submit_import_devices_form ( ) {
        document.getElementById("import-devices-form").submit(); 
    }
</script>