<?php

	$base_url = base_url ( 'admin/device_management/types' );
	
	if ( ! empty ( $_GET ) ) {
		$query_string = $_GET;
		
		if ( isset ( $query_string['order_by'] ) ) {
			unset ( $query_string['order_by'] );
		}
		
		if ( isset ( $query_string['order'] ) ) {
			unset ( $query_string['order'] );
		}
		
		if ( ! empty ( $query_string ) ) {
			$query_string = http_build_query ( $query_string );
			$base_url = $base_url . '?' . $query_string;
		}
	}
?>
<div class="row">
    <div class="col-md-12 m-b-30">
        <div class="d-block flex-nowrap align-items-center">
            <div class="page-title ">
                <h1 class="title-icon">
                    <i class="fa fa-server"></i><strong>Device Types</strong>
                </h1>
                <div class="invoice-buttons text-right"> 
                    <a href="#" class="btn btn-info add-device-type" data-toggle="modal" data-target="#type-form-model">Add New Type</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Notification -->
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">All Device Types</h4>
            </div>
            <div class="card-body">
                <div class="datatable-wrapper table-responsive">        
                    <div class="datatable-wrapper table-responsive table-devices">
                        <table class="dataTable display compact table">
                            <thead>
                                <tr>
                                    <th><a href="<?php echo sort_url ( $base_url, 'id' ); ?>">Name</a></th>
                                    <th><a href="<?php echo sort_url ( $base_url, 'tag_name' ); ?>">Photo</a></th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ( ! empty ( $devices ) ) {
                                    
                				    foreach ( $devices as $key => $device ) {
                				        ?>
                						<tr>
                							<td><?php echo $device['name']; ?></td>
                							<td>
                							    <?php
                							    if ( ! empty ( $device['image'] ) ) { ?>
                							        <img src="<?php echo base_url( 'public/uploads/user_files/' . $device['image'] ); ?>" width="100"/>
                							    <?php } else {
                							        echo "No image found.";
                							    } ?>
                							</td>
                                            <td>
                                                <a class="edit btn btn-info" data-toggle="modal" data-target="#type-form-model" onclick="edit_device_type_form('<?php echo $device['id']; ?>', '<?php echo $device['name']; ?>');"><i class="fa fa-pencil fs-16"></i> Edit</a>
                								<button class="btn btn-danger text-white" data-toggle="modal" onclick="delete_device_type( '<?php echo $device['id']; ?>' );" data-target="#delete">Delete</button>
                							</td>
                						</tr>
                				        <?php
                				        
                				    } 
            				    } ?>
            
                            </tbody>
            
                        </table>
                    </div>
        
                	<div class="col-sm-12 col-md-12 d-flex justify-content-between pt-1 pb-4 align-items-center">
                		<div class="dataTables_info" id="datatable_info" role="status" aria-live="polite">
                		    Showing <?php echo (($offset==0)?'1':$offset); ?> to <?php echo (($per_page_limit>$total_tags)?$total_tags:$per_page_limit); ?> of <?php echo $total_tags; ?> entries
                		</div>
                	    <div class="dataTables_paginate paging_simple_numbers">
                		    <?php echo $this->pagination->create_links (); ?>
                		</div>
                	</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function delete_device_type ( id ) {
        if ( id ) {
            $('#delete_form').attr( 'action', location.href );
            $('#delete_id').val( id );
        }
    }
    function submit_device_type_form ( ) {
        var name = $('#name').val();
        if( name == ''  ) {
            alert('Please enter device name.');
        } else {
            document.getElementById("device-type-form").submit(); 
        }
    }
    
    function edit_device_type_form ( id, name, color ) {
    
        $('#device_type_id').val( id );
        $('#name').val( name );
    
    }
  
</script>