<?php

	$base_url = base_url ( 'admin/device_management/index' );
	
	if ( ! empty ( $_GET ) ) {
		$query_string = $_GET;
		
		if ( isset ( $query_string['order_by'] ) ) {
			unset ( $query_string['order_by'] );
		}
		
		if ( isset ( $query_string['order'] ) ) {
			unset ( $query_string['order'] );
		}
		
		if ( ! empty ( $query_string ) ) {
			$query_string = http_build_query ( $query_string );
			$base_url = $base_url . '?' . $query_string;
		}
	}
?>
<div class="row">
    <div class="col-md-12 m-b-30">
        <div class="d-block flex-nowrap align-items-center">
            <div class="page-title ">
                <h1>
                    <strong>Team Profile</strong>
                </h1>
               
            </div>
        </div>
    </div>
</div>
<!-- Notification -->
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">All Users</h4>
            </div>
            <div class="card-body">
                <div class="datatable-wrapper table-responsive">        
                    <div class="datatable-wrapper table-responsive table-devices">
                       <table class="dataTable display compact table">
                        <thead>
                            <tr>
                                <th>Image</th>
                                <th>Company Name</th>
                                <th>Email</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                           <tbody>
                                <?php
        				    foreach ( $teams as $key => $user ) { ?>
                               <tr>
                                   <td><img width="100" src="data:image/png;base64,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" alt=""></td>
                                   <td><?php echo $user['company'] ?></td>
                                   <td><?php echo $user['email'] ?></td>
                                   <td><a href="<?php echo base_url ( 'admin/profile/details' )  ?>/<?php echo $user['id'] ?>" class="edit btn btn-info">View Detail</a></td>
                               </tr>
                               
                                <?php
        				    } ?>
                                
                                   </tbody>
                    </table>
                    </div>
        
                	<!--<div class="col-sm-12 col-md-12 d-flex justify-content-between pt-1 pb-4 align-items-center">-->
                	<!--	<div class="dataTables_info" id="datatable_info" role="status" aria-live="polite">-->
                	<!--	    Showing <?php echo (($offset==0)?'1':$offset); ?> to <?php echo (($per_page_limit>$total_tags)?$total_tags:$per_page_limit); ?> of <?php echo $total_tags; ?> entries-->
                	<!--	</div>-->
                	<!--    <div class="dataTables_paginate paging_simple_numbers">-->
                	<!--	    <?php echo $this->pagination->create_links (); ?>-->
                	<!--	</div>-->
                	<!--</div>-->
                </div>
            </div>
        </div>
    </div>
</div>

