<?php

	$base_url = base_url ( 'admin/theme_management/index' );
	
	if ( ! empty ( $_GET ) ) {
		$query_string = $_GET;
		
		if ( isset ( $query_string['order_by'] ) ) {
			unset ( $query_string['order_by'] );
		}
		
		if ( isset ( $query_string['order'] ) ) {
			unset ( $query_string['order'] );
		}
		
		if ( ! empty ( $query_string ) ) {
			$query_string = http_build_query ( $query_string );
			$base_url = $base_url . '?' . $query_string;
		}
	}

?>

<div class="row">
    <div class="col-md-12 m-b-30">
        <div class="d-block flex-nowrap align-items-center">
            <div class="page-title ">
                <h1>
                    <strong>Profile Themes</strong>
                </h1>

                <div class="invoice-buttons text-right"> 
                    <a href="#" class="btn btn-info add-theme" data-toggle="modal" onclick="edit_theme_form('', '', '');" data-target="#theme-form-model">Add New Theme</a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Notification -->
<div class="row">
    <div class="col-lg-12">
        <div class="card">
        <div class="card-header">
           <h4 class="card-title">All Users</h4>
            </div>
               <div class="card-body">
              <div class="datatable-wrapper table-responsive">
            <table class="dataTable display compact table">
                <thead>
                    <tr>
                        <th class="<?php echo sort_class ( 'name' ); ?>"><a href="<?php echo sort_url ( $base_url, 'name' ); ?>">Name</a></th>
                        <th class="<?php echo sort_class ( 'color' ); ?>"><a href="<?php echo sort_url ( $base_url, 'price' ); ?>">Color</a></th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    
                    <?php
                    if ( ! empty ( $themes ) ) {
                        foreach ( $themes as $key => $theme ) { ?>
    						<tr id="theme-<?php echo $theme['id']; ?>">
    							<td><?php echo $theme['name']; ?></td>
    							<td><input type="color" class="form-control form-control-color" readonly=true value="<?php echo $theme['color']; ?>"/></td>
    							<td>
    							    <a class="edit btn btn-info" data-toggle="modal" data-target="#theme-form-model" onclick="edit_theme_form('<?php echo $theme['id']; ?>', '<?php echo $theme['name']; ?>', '<?php echo $theme['color']; ?>');"><i class="fa fa-pencil fs-16"></i> Edit</a>
                                    <a href="#" class="btn btn-danger" data-toggle="modal" onclick="delete_theme( '<?php echo $theme['id']; ?>' );" data-target="#delete">Delete</a>
    							</td>
    						</tr>
    				        <?php
    				    } 
				    } ?>

                </tbody>

            </table>
        </div>
        </div>
        <div class="row">
        	<div class="col-sm-12 col-md-5">
        		<div class="dataTables_info" id="datatable_info" role="status" aria-live="polite">Showing <?php echo (($offset==0)?'1':$offset); ?> to <?php echo (($per_page_limit>$total_themes)?$total_themes:$per_page_limit); ?> of <?php echo $total_themes; ?> entries</div>
        	</div>
        	<div class="col-sm-12 col-md-7">
        		<div class="dataTables_paginate paging_simple_numbers">
        		    <?php echo $this->pagination->create_links (); ?>
        		</div>
        	</div>
        </div>
         </div>
    </div>
</div>
<script>
function submit_theme_form ( ) {
    var name = $('#theme_name').val();
    var color = $('#theme_color').val();
    if( name == ''  ) {
        alert('Please enter name.');
    } else if( color == '' ) {
        alert( 'Please enter color.' );
    } else {
        document.getElementById("theme-form").submit(); 
    }
}

function edit_theme_form ( id, name, color ) {

    $('#theme_id').val( id );
    $('#theme_name').val( name );
    $('#theme_color').val( color );

}
function delete_theme ( id ) {
    if ( id ) {
        $('#delete_form').attr( 'action', location.href );
        $('#delete_id').val( id );
    }
}
</script>
