<?php

	$base_url = base_url ( 'admin/user_management/index' );
	
	if ( ! empty ( $_GET ) ) {
		$query_string = $_GET;
		
		if ( isset ( $query_string['order_by'] ) ) {
			unset ( $query_string['order_by'] );
		}
		
		if ( isset ( $query_string['order'] ) ) {
			unset ( $query_string['order'] );
		}
		
		if ( ! empty ( $query_string ) ) {
			$query_string = http_build_query ( $query_string );
			$base_url = $base_url . '?' . $query_string;
		}
	}

?>

<div class="row">
    <div class="col-md-12 m-b-30">
        <div class="d-block flex-nowrap align-items-center">
            <div class="page-title ">
                <h1 class="title-icon">
                    <i class="fa fa-user"></i><strong>User Management</strong>
                </h1>
            </div>
        </div>
    </div>
</div>
<!-- Notification -->
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">All Users</h4>
            </div>
            <div class="card-body">
                <div class="datatable-wrapper table-responsive">
                    <table class="dataTable display compact table">
                        <thead>
                            <tr>
                                <th>Image</th>
                                <th class="<?php echo sort_class ( 'full_name' ); ?>"><a href="<?php echo sort_url ( $base_url, 'full_name' ); ?>">Full Name</a></th>
                                <th class="<?php echo sort_class ( 'email' ); ?>"><a href="<?php echo sort_url ( $base_url, 'email' ); ?>">Email</a></th>
                                <th>Plan</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
        
                        <tbody>
                            
                            <?php
        				    foreach ( $users as $key => $user ) { ?>
        						<tr class="<?php echo (($key%2==0)?'even':'odd'); ?> ustatus-<?php echo $user['user_status']; ?>">
        							<td>
        							    <?php
        							    $upload_dir_path = $this->config->item( 'upload_dir_path' );
        							    if( ! empty( $user['photo'] ) && file_exists ( $upload_dir_path . 'user_images/thumb/' . $user['photo'] ) ) {
        							        $profile_img_url = base_url ( 'public/uploads/user_images/thumb/' . $user['photo'] ); 
        							    } else {
        							        $profile_img_url = base_url( 'public/admin/assets/img/default-user.png' );
        							    }
        							    ?>
        							    <img class="rounded-circle" width="35" src="<?php echo $profile_img_url; ?>" alt="">
        							</td>
        							<td><?php echo $user['full_name']; ?></td>
        							<td><a href="mailto:<?php echo $user['email']; ?>"><strong><?php echo $user['email']; ?></strong></a></td>
        							<td><?php echo ucfirst($user['plan']); ?></td>
        							<td>
        							    <?php
        							    if ( $user['user_status'] == 1 ) { ?>
        								    <button class="btn btn-danger text-white user_btn" title="Block User" data-toggle="modal" onclick="block_user( '<?php echo $user['id']; ?>' );" data-target="#block"><i class="fa fa-user-times"></i></button>
        							    <?php } else { ?>
        							        <button class="btn btn-success text-white user_btn" title="Unblock User" data-toggle="modal" onclick="unblock_user( '<?php echo $user['id']; ?>' );" data-target="#unblock"><i class="fa fa-user-times"></i></button>
        							        <?php
        							    } ?>
        							</td>
        						</tr>
        				        <?php
        				    } ?>
        
                        </tbody>
        
                    </table>
                </div>
            </div>
        	<div class="col-sm-12 col-md-12 d-flex justify-content-between pt-1 pb-4 align-items-center">
        		<div class="dataTables_info" id="datatable_info" role="status" aria-live="polite">
                    Showing <?php echo (($offset==0)?'1':$offset); ?> to <?php echo (($per_page_limit>$total_users)?$total_users:$per_page_limit); ?> of <?php echo $total_users; ?> entries
        		</div>
        		<div class="dataTables_paginate paging_simple_numbers">
        		    <?php echo $this->pagination->create_links (); ?>
        		</div>
            </div>
        </div>
    </div>
</div>

<script>
    function block_user ( user_id ) {
        if ( user_id ) {
            $('#user_block_form').attr( 'action', location.href );
            $('#block_user_id').val( user_id );
        }
    }
    function unblock_user ( user_id ) {
        if ( user_id ) {
            $('#user_unblock_form').attr( 'action', location.href );
            $('#unblock_user_id').val( user_id );
        }
    }
</script>